@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.ListListSchemaPlainArgs.builder
import com.pulumi.azurenative.azuredatatransfer.kotlin.enums.SchemaStatus
import com.pulumi.core.Either
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property connectionId Connection ID associated with this schema
 * @property content Content of the schema
 * @property id ID associated with this schema
 * @property name Name of the schema
 * @property pipelineName The name for the pipeline that is to be requested.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property status Status of the schema
 */
public data class ListListSchemaPlainArgs(
    public val connectionId: String? = null,
    public val content: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val pipelineName: String,
    public val resourceGroupName: String,
    public val status: Either<String, SchemaStatus>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.ListListSchemaPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.ListListSchemaPlainArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.ListListSchemaPlainArgs.builder()
            .connectionId(connectionId?.let({ args0 -> args0 }))
            .content(content?.let({ args0 -> args0 }))
            .id(id?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .pipelineName(pipelineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .status(
                status?.let({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ListListSchemaPlainArgs].
 */
@PulumiTagMarker
public class ListListSchemaPlainArgsBuilder internal constructor() {
    private var connectionId: String? = null

    private var content: String? = null

    private var id: String? = null

    private var name: String? = null

    private var pipelineName: String? = null

    private var resourceGroupName: String? = null

    private var status: Either<String, SchemaStatus>? = null

    /**
     * @param value Connection ID associated with this schema
     */
    @JvmName("noxxlwdmsejjlpxo")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.connectionId = mapped
    }

    /**
     * @param value Content of the schema
     */
    @JvmName("qaitcgtvfvrjtctk")
    public suspend fun content(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.content = mapped
    }

    /**
     * @param value ID associated with this schema
     */
    @JvmName("vlnbwypjvbdierie")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Name of the schema
     */
    @JvmName("lusqjbksrpkimqad")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The name for the pipeline that is to be requested.
     */
    @JvmName("ricsjlpctdurvgrq")
    public suspend fun pipelineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gsgwxkysbncbnuej")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Status of the schema
     */
    @JvmName("fbajfpabfrrnkcay")
    public suspend fun status(`value`: Either<String, SchemaStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Status of the schema
     */
    @JvmName("hkrddbkgsmktseiu")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SchemaStatus>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Status of the schema
     */
    @JvmName("sgiicyhyeglrvcnu")
    public fun status(`value`: SchemaStatus) {
        val toBeMapped = Either.ofRight<String, SchemaStatus>(value)
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): ListListSchemaPlainArgs = ListListSchemaPlainArgs(
        connectionId = connectionId,
        content = content,
        id = id,
        name = name,
        pipelineName = pipelineName ?: throw PulumiNullFieldException("pipelineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        status = status,
    )
}
