@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.SelectedResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A resource selected from ARM
 * @property id Id of the connection
 * @property location Location of the connection
 * @property name Name of the connection
 * @property subscriptionName Name of the subscription with the connection
 */
public data class SelectedResourceArgs(
    public val id: Output<String>,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val subscriptionName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.SelectedResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.SelectedResourceArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.SelectedResourceArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .subscriptionName(subscriptionName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SelectedResourceArgs].
 */
@PulumiTagMarker
public class SelectedResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var subscriptionName: Output<String>? = null

    /**
     * @param value Id of the connection
     */
    @JvmName("lyfvytaoctcxmirl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Location of the connection
     */
    @JvmName("ovhdmhtytjgrvasd")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the connection
     */
    @JvmName("lyjnmrvuvpgfknqi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the subscription with the connection
     */
    @JvmName("cclcjbgdxyddnxco")
    public suspend fun subscriptionName(`value`: Output<String>) {
        this.subscriptionName = value
    }

    /**
     * @param value Id of the connection
     */
    @JvmName("vwgybbwgpdufbvnc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Location of the connection
     */
    @JvmName("afeystekjgbduhgn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the connection
     */
    @JvmName("vrjrinljxwbegpnq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the subscription with the connection
     */
    @JvmName("iovniwtnddhrffqf")
    public suspend fun subscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionName = mapped
    }

    internal fun build(): SelectedResourceArgs = SelectedResourceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        location = location,
        name = name,
        subscriptionName = subscriptionName,
    )
}
