@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.inputs

import com.pulumi.azurenative.azuredatatransfer.inputs.SubscriberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property email Email of the subscriber
 * @property notifications Number specifying what notifications to receive
 */
public data class SubscriberArgs(
    public val email: Output<String>? = null,
    public val notifications: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuredatatransfer.inputs.SubscriberArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredatatransfer.inputs.SubscriberArgs =
        com.pulumi.azurenative.azuredatatransfer.inputs.SubscriberArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .notifications(notifications?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriberArgs].
 */
@PulumiTagMarker
public class SubscriberArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var notifications: Output<Double>? = null

    /**
     * @param value Email of the subscriber
     */
    @JvmName("uopufrssgshkuqor")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Number specifying what notifications to receive
     */
    @JvmName("jmjqijcdhcbsymax")
    public suspend fun notifications(`value`: Output<Double>) {
        this.notifications = value
    }

    /**
     * @param value Email of the subscriber
     */
    @JvmName("diahfwfrrxbisoeo")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Number specifying what notifications to receive
     */
    @JvmName("sxgbfmxgybkikvuh")
    public suspend fun notifications(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    internal fun build(): SubscriberArgs = SubscriberArgs(
        email = email,
        notifications = notifications,
    )
}
