@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredatatransfer.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Internal metadata of the connection inside pipeline.
 * @property operationStatus Operation status associated with the last patch request
 * @property statusSetBy User that last set the approved status for this connection
 */
public data class InternalMetadataPropertiesResponse(
    public val operationStatus: OperationStatusPropertiesResponse? = null,
    public val statusSetBy: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azuredatatransfer.outputs.InternalMetadataPropertiesResponse):
            InternalMetadataPropertiesResponse = InternalMetadataPropertiesResponse(
            operationStatus = javaType.operationStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuredatatransfer.kotlin.outputs.OperationStatusPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            statusSetBy = javaType.statusSetBy(),
        )
    }
}
