@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureplaywrightservice.kotlin

import com.pulumi.azurenative.azureplaywrightservice.AzureplaywrightserviceFunctions.getAccountPlain
import com.pulumi.azurenative.azureplaywrightservice.kotlin.inputs.GetAccountPlainArgs
import com.pulumi.azurenative.azureplaywrightservice.kotlin.inputs.GetAccountPlainArgsBuilder
import com.pulumi.azurenative.azureplaywrightservice.kotlin.outputs.GetAccountResult
import com.pulumi.azurenative.azureplaywrightservice.kotlin.outputs.GetAccountResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object AzureplaywrightserviceFunctions {
    /**
     * Get a Account
     * Azure REST API version: 2023-10-01-preview.
     * Other available API versions: 2024-02-01.
     * @param argument null
     * @return An account resource
     */
    public suspend fun getAccount(argument: GetAccountPlainArgs): GetAccountResult =
        toKotlin(getAccountPlain(argument.toJava()).await())

    /**
     * @see [getAccount].
     * @param name Name of account
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return An account resource
     */
    public suspend fun getAccount(name: String, resourceGroupName: String): GetAccountResult {
        val argument = GetAccountPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
        )
        return toKotlin(getAccountPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccount].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azureplaywrightservice&#46;kotlin&#46;inputs&#46;GetAccountPlainArgs].
     * @return An account resource
     */
    public suspend fun getAccount(argument: suspend GetAccountPlainArgsBuilder.() -> Unit):
        GetAccountResult {
        val builder = GetAccountPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getAccountPlain(builtArgument.toJava()).await())
    }
}
