@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.DeploymentArgs.builder
import com.pulumi.azurenative.azuresphere.kotlin.inputs.ImageArgs
import com.pulumi.azurenative.azuresphere.kotlin.inputs.ImageArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An deployment resource belonging to a device group resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2024-04-01.
 * ## Example Usage
 * ### Deployments_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deployment = new AzureNative.AzureSphere.Deployment("deployment", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         DeploymentName = "MyDeployment1",
 *         DeviceGroupName = "myDeviceGroup1",
 *         ProductName = "MyProduct1",
 *         ResourceGroupName = "MyResourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewDeployment(ctx, "deployment", &azuresphere.DeploymentArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			DeploymentName:    pulumi.String("MyDeployment1"),
 * 			DeviceGroupName:   pulumi.String("myDeviceGroup1"),
 * 			ProductName:       pulumi.String("MyProduct1"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.Deployment;
 * import com.pulumi.azurenative.azuresphere.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deployment = new Deployment("deployment", DeploymentArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .deploymentName("MyDeployment1")
 *             .deviceGroupName("myDeviceGroup1")
 *             .productName("MyProduct1")
 *             .resourceGroupName("MyResourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:Deployment MyDeployment1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/deployments/{deploymentName}
 * ```
 * @property catalogName Name of catalog
 * @property deployedImages Images deployed
 * @property deploymentId Deployment ID
 * @property deploymentName Deployment name. Use .default for deployment creation and to get the current deployment for the associated device group.
 * @property deviceGroupName Name of device group.
 * @property productName Name of product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DeploymentArgs(
    public val catalogName: Output<String>? = null,
    public val deployedImages: Output<List<ImageArgs>>? = null,
    public val deploymentId: Output<String>? = null,
    public val deploymentName: Output<String>? = null,
    public val deviceGroupName: Output<String>? = null,
    public val productName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.DeploymentArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.DeploymentArgs =
        com.pulumi.azurenative.azuresphere.DeploymentArgs.builder()
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .deployedImages(
                deployedImages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deploymentId(deploymentId?.applyValue({ args0 -> args0 }))
            .deploymentName(deploymentName?.applyValue({ args0 -> args0 }))
            .deviceGroupName(deviceGroupName?.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var catalogName: Output<String>? = null

    private var deployedImages: Output<List<ImageArgs>>? = null

    private var deploymentId: Output<String>? = null

    private var deploymentName: Output<String>? = null

    private var deviceGroupName: Output<String>? = null

    private var productName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("cejedhcffxhddrin")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value Images deployed
     */
    @JvmName("ixuqklbfxhatvcgn")
    public suspend fun deployedImages(`value`: Output<List<ImageArgs>>) {
        this.deployedImages = value
    }

    @JvmName("byrjkecwigmjqyco")
    public suspend fun deployedImages(vararg values: Output<ImageArgs>) {
        this.deployedImages = Output.all(values.asList())
    }

    /**
     * @param values Images deployed
     */
    @JvmName("tqnoiccmjfppfgef")
    public suspend fun deployedImages(values: List<Output<ImageArgs>>) {
        this.deployedImages = Output.all(values)
    }

    /**
     * @param value Deployment ID
     */
    @JvmName("qteglofhrmmtykvd")
    public suspend fun deploymentId(`value`: Output<String>) {
        this.deploymentId = value
    }

    /**
     * @param value Deployment name. Use .default for deployment creation and to get the current deployment for the associated device group.
     */
    @JvmName("fidmbffujeeefcgo")
    public suspend fun deploymentName(`value`: Output<String>) {
        this.deploymentName = value
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("bwtonmebxvhtckqj")
    public suspend fun deviceGroupName(`value`: Output<String>) {
        this.deviceGroupName = value
    }

    /**
     * @param value Name of product.
     */
    @JvmName("jlhldchgswybeqsa")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uqfvhxikyirufkxx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of catalog
     */
    @JvmName("tsqyduytyqpxaenw")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value Images deployed
     */
    @JvmName("ntknmuiwfmekyxbr")
    public suspend fun deployedImages(`value`: List<ImageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deployedImages = mapped
    }

    /**
     * @param argument Images deployed
     */
    @JvmName("xrrhpvctthiitipr")
    public suspend fun deployedImages(argument: List<suspend ImageArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ImageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.deployedImages = mapped
    }

    /**
     * @param argument Images deployed
     */
    @JvmName("attmtucufvuonfxs")
    public suspend fun deployedImages(vararg argument: suspend ImageArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ImageArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.deployedImages = mapped
    }

    /**
     * @param argument Images deployed
     */
    @JvmName("ggeobgwqgierfaos")
    public suspend fun deployedImages(argument: suspend ImageArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ImageArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.deployedImages = mapped
    }

    /**
     * @param values Images deployed
     */
    @JvmName("nabskwtbmsdffrmp")
    public suspend fun deployedImages(vararg values: ImageArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deployedImages = mapped
    }

    /**
     * @param value Deployment ID
     */
    @JvmName("fnghdluqcxpnjlsf")
    public suspend fun deploymentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentId = mapped
    }

    /**
     * @param value Deployment name. Use .default for deployment creation and to get the current deployment for the associated device group.
     */
    @JvmName("ipijhrfrkyurohjv")
    public suspend fun deploymentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentName = mapped
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("rtkkcwnnpkucymdd")
    public suspend fun deviceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceGroupName = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("danpbxykwsgombxb")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kvbjtenyqujpiwoa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        catalogName = catalogName,
        deployedImages = deployedImages,
        deploymentId = deploymentId,
        deploymentName = deploymentName,
        deviceGroupName = deviceGroupName,
        productName = productName,
        resourceGroupName = resourceGroupName,
    )
}
