@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.ImageArgs.builder
import com.pulumi.azurenative.azuresphere.kotlin.enums.RegionalDataBoundary
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An image resource belonging to a catalog resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2024-04-01.
 * ## Example Usage
 * ### Image_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var image = new AzureNative.AzureSphere.Image("image", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         Image = "bXliYXNlNjRzdHJpbmc=",
 *         ImageName = ".default",
 *         ResourceGroupName = "MyResourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewImage(ctx, "image", &azuresphere.ImageArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			Image:             pulumi.String("bXliYXNlNjRzdHJpbmc="),
 * 			ImageName:         pulumi.String(".default"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.Image;
 * import com.pulumi.azurenative.azuresphere.ImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var image = new Image("image", ImageArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .image("bXliYXNlNjRzdHJpbmc=")
 *             .imageName(".default")
 *             .resourceGroupName("MyResourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:Image MyProduct1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/images/{imageName}
 * ```
 * @property catalogName Name of catalog
 * @property image Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads.
 * @property imageId Image ID
 * @property imageName Image name. Use an image GUID for GA versions of the API.
 * @property regionalDataBoundary Regional data boundary for an image
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ImageArgs(
    public val catalogName: Output<String>? = null,
    public val image: Output<String>? = null,
    public val imageId: Output<String>? = null,
    public val imageName: Output<String>? = null,
    public val regionalDataBoundary: Output<Either<String, RegionalDataBoundary>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.ImageArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.ImageArgs =
        com.pulumi.azurenative.azuresphere.ImageArgs.builder()
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0 }))
            .imageId(imageId?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .regionalDataBoundary(
                regionalDataBoundary?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageArgs].
 */
@PulumiTagMarker
public class ImageArgsBuilder internal constructor() {
    private var catalogName: Output<String>? = null

    private var image: Output<String>? = null

    private var imageId: Output<String>? = null

    private var imageName: Output<String>? = null

    private var regionalDataBoundary: Output<Either<String, RegionalDataBoundary>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("tpwnrqeebwvkxtoi")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads.
     */
    @JvmName("lnnsyjjyandxncis")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Image ID
     */
    @JvmName("nttmvsqtqydwrdwb")
    public suspend fun imageId(`value`: Output<String>) {
        this.imageId = value
    }

    /**
     * @param value Image name. Use an image GUID for GA versions of the API.
     */
    @JvmName("hohpknysxscshoul")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("efpckhvimwnukmdq")
    public suspend fun regionalDataBoundary(`value`: Output<Either<String, RegionalDataBoundary>>) {
        this.regionalDataBoundary = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("piguhcysxkylksab")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of catalog
     */
    @JvmName("kwwbsrrbtkqxqogr")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value Image as a UTF-8 encoded base 64 string on image create. This field contains the image URI on image reads.
     */
    @JvmName("fxdjsfjoqkhstyxw")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Image ID
     */
    @JvmName("jqcyiykhheiittgd")
    public suspend fun imageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageId = mapped
    }

    /**
     * @param value Image name. Use an image GUID for GA versions of the API.
     */
    @JvmName("edsdheeiclagflkm")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("wxsfkffceporuvbq")
    public suspend fun regionalDataBoundary(`value`: Either<String, RegionalDataBoundary>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("rsixotrpywbcovrm")
    public fun regionalDataBoundary(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RegionalDataBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value Regional data boundary for an image
     */
    @JvmName("cinckvqviuqwfhrh")
    public fun regionalDataBoundary(`value`: RegionalDataBoundary) {
        val toBeMapped = Either.ofRight<String, RegionalDataBoundary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionalDataBoundary = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ycmpowqxtpjuutso")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ImageArgs = ImageArgs(
        catalogName = catalogName,
        image = image,
        imageId = imageId,
        imageName = imageName,
        regionalDataBoundary = regionalDataBoundary,
        resourceGroupName = resourceGroupName,
    )
}
