@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.GetDevicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property deviceGroupName Name of device group.
 * @property deviceName Device name
 * @property productName Name of product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDevicePlainArgs(
    public val catalogName: String,
    public val deviceGroupName: String,
    public val deviceName: String,
    public val productName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.GetDevicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.GetDevicePlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.GetDevicePlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .deviceGroupName(deviceGroupName.let({ args0 -> args0 }))
            .deviceName(deviceName.let({ args0 -> args0 }))
            .productName(productName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevicePlainArgs].
 */
@PulumiTagMarker
public class GetDevicePlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var deviceGroupName: String? = null

    private var deviceName: String? = null

    private var productName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("ikxwtkrhbuxkthqe")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("tbddmitxsnqnnook")
    public suspend fun deviceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceGroupName = mapped
    }

    /**
     * @param value Device name
     */
    @JvmName("vyedtkvnvhqeyrho")
    public suspend fun deviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deviceName = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("cqxotdsfmqhucadq")
    public suspend fun productName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ulovysjuwllnpron")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDevicePlainArgs = GetDevicePlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        deviceGroupName = deviceGroupName ?: throw PulumiNullFieldException("deviceGroupName"),
        deviceName = deviceName ?: throw PulumiNullFieldException("deviceName"),
        productName = productName ?: throw PulumiNullFieldException("productName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
