@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.GetImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property imageName Image name. Use an image GUID for GA versions of the API.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetImagePlainArgs(
    public val catalogName: String,
    public val imageName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.GetImagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.GetImagePlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.GetImagePlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .imageName(imageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagePlainArgs].
 */
@PulumiTagMarker
public class GetImagePlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var imageName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("bculxhleypwhdxdl")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value Image name. Use an image GUID for GA versions of the API.
     */
    @JvmName("dpvukbkdasfvcspb")
    public suspend fun imageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.imageName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("egsooptjcvxqkmrx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetImagePlainArgs = GetImagePlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        imageName = imageName ?: throw PulumiNullFieldException("imageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
