@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeviceGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property deviceGroupName Device Group name.
 * @property filter Filter the result list using the given expression
 * @property maxpagesize The maximum number of result items per page.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property skip The number of result items to skip.
 * @property top The number of result items to return.
 */
public data class ListCatalogDeviceGroupsPlainArgs(
    public val catalogName: String,
    public val deviceGroupName: String? = null,
    public val filter: String? = null,
    public val maxpagesize: Int? = null,
    public val resourceGroupName: String,
    public val skip: Int? = null,
    public val top: Int? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeviceGroupsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeviceGroupsPlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.ListCatalogDeviceGroupsPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .deviceGroupName(deviceGroupName?.let({ args0 -> args0 }))
            .filter(filter?.let({ args0 -> args0 }))
            .maxpagesize(maxpagesize?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .skip(skip?.let({ args0 -> args0 }))
            .top(top?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListCatalogDeviceGroupsPlainArgs].
 */
@PulumiTagMarker
public class ListCatalogDeviceGroupsPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var deviceGroupName: String? = null

    private var filter: String? = null

    private var maxpagesize: Int? = null

    private var resourceGroupName: String? = null

    private var skip: Int? = null

    private var top: Int? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("aokabmxbevrcqeua")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value Device Group name.
     */
    @JvmName("gkcuuvquayodkukh")
    public suspend fun deviceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.deviceGroupName = mapped
    }

    /**
     * @param value Filter the result list using the given expression
     */
    @JvmName("oysajihxacumnorr")
    public suspend fun filter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filter = mapped
    }

    /**
     * @param value The maximum number of result items per page.
     */
    @JvmName("fogxijpsgjppaxef")
    public suspend fun maxpagesize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxpagesize = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tqwudcedlhsewtlq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The number of result items to skip.
     */
    @JvmName("opphjiffjapwyksh")
    public suspend fun skip(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skip = mapped
    }

    /**
     * @param value The number of result items to return.
     */
    @JvmName("jeoiekpfdbjidvqe")
    public suspend fun top(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.top = mapped
    }

    internal fun build(): ListCatalogDeviceGroupsPlainArgs = ListCatalogDeviceGroupsPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        deviceGroupName = deviceGroupName,
        filter = filter,
        maxpagesize = maxpagesize,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        skip = skip,
        top = top,
    )
}
