@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An device resource belonging to a device group resource.
 * @property chipSku SKU of the chip
 * @property deviceId Device ID
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastAvailableOsVersion OS version available for installation when update requested
 * @property lastInstalledOsVersion OS version running on device when update requested
 * @property lastOsUpdateUtc Time when update requested and new OS version available
 * @property lastUpdateRequestUtc Time when update was last requested
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDeviceResult(
    public val chipSku: String,
    public val deviceId: String? = null,
    public val id: String,
    public val lastAvailableOsVersion: String,
    public val lastInstalledOsVersion: String,
    public val lastOsUpdateUtc: String,
    public val lastUpdateRequestUtc: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.GetDeviceResult):
            GetDeviceResult = GetDeviceResult(
            chipSku = javaType.chipSku(),
            deviceId = javaType.deviceId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastAvailableOsVersion = javaType.lastAvailableOsVersion(),
            lastInstalledOsVersion = javaType.lastInstalledOsVersion(),
            lastOsUpdateUtc = javaType.lastOsUpdateUtc(),
            lastUpdateRequestUtc = javaType.lastUpdateRequestUtc(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
