@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Paged collection of DeviceInsight items
 * @property nextLink The link to the next page of items
 * @property value The DeviceInsight items on this page
 */
public data class ListCatalogDeviceInsightsResult(
    public val nextLink: String? = null,
    public val `value`: List<DeviceInsightResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.ListCatalogDeviceInsightsResult):
            ListCatalogDeviceInsightsResult = ListCatalogDeviceInsightsResult(
            nextLink = javaType.nextLink().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azuresphere.kotlin.outputs.DeviceInsightResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
