@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin

import com.pulumi.azurenative.azurestack.CustomerSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Customer subscription.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * Other available API versions: 2020-06-01-preview.
 * ## Example Usage
 * ### Creates a new customer subscription under a registration.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customerSubscription = new AzureNative.AzureStack.CustomerSubscription("customerSubscription", new()
 *     {
 *         CustomerSubscriptionName = "E09A4E93-29A7-4EBA-A6D4-76202383F07F",
 *         RegistrationName = "testregistration",
 *         ResourceGroup = "azurestack",
 *         TenantId = "dbab3982-796f-4d03-9908-044c08aef8a2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestack/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestack.NewCustomerSubscription(ctx, "customerSubscription", &azurestack.CustomerSubscriptionArgs{
 * 			CustomerSubscriptionName: pulumi.String("E09A4E93-29A7-4EBA-A6D4-76202383F07F"),
 * 			RegistrationName:         pulumi.String("testregistration"),
 * 			ResourceGroup:            pulumi.String("azurestack"),
 * 			TenantId:                 pulumi.String("dbab3982-796f-4d03-9908-044c08aef8a2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestack.CustomerSubscription;
 * import com.pulumi.azurenative.azurestack.CustomerSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customerSubscription = new CustomerSubscription("customerSubscription", CustomerSubscriptionArgs.builder()
 *             .customerSubscriptionName("E09A4E93-29A7-4EBA-A6D4-76202383F07F")
 *             .registrationName("testregistration")
 *             .resourceGroup("azurestack")
 *             .tenantId("dbab3982-796f-4d03-9908-044c08aef8a2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestack:CustomerSubscription myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/customerSubscriptions/{customerSubscriptionName}
 * ```
 * @property customerSubscriptionName Name of the product.
 * @property registrationName Name of the Azure Stack registration.
 * @property resourceGroup Name of the resource group.
 * @property tenantId Tenant Id.
 */
public data class CustomerSubscriptionArgs(
    public val customerSubscriptionName: Output<String>? = null,
    public val registrationName: Output<String>? = null,
    public val resourceGroup: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestack.CustomerSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestack.CustomerSubscriptionArgs =
        com.pulumi.azurenative.azurestack.CustomerSubscriptionArgs.builder()
            .customerSubscriptionName(customerSubscriptionName?.applyValue({ args0 -> args0 }))
            .registrationName(registrationName?.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerSubscriptionArgs].
 */
@PulumiTagMarker
public class CustomerSubscriptionArgsBuilder internal constructor() {
    private var customerSubscriptionName: Output<String>? = null

    private var registrationName: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Name of the product.
     */
    @JvmName("fvbnhnhjhurftsam")
    public suspend fun customerSubscriptionName(`value`: Output<String>) {
        this.customerSubscriptionName = value
    }

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("wryugftaipneuyux")
    public suspend fun registrationName(`value`: Output<String>) {
        this.registrationName = value
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("qsqenkadlvwepoki")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value Tenant Id.
     */
    @JvmName("prqjgrvqcvvttsso")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Name of the product.
     */
    @JvmName("abbejjpiofufxtqh")
    public suspend fun customerSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerSubscriptionName = mapped
    }

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("ufauegiwsdmeaqwb")
    public suspend fun registrationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registrationName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("gbnyivkspkwwxdpe")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value Tenant Id.
     */
    @JvmName("ilfimsrpfdgkpjfu")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): CustomerSubscriptionArgs = CustomerSubscriptionArgs(
        customerSubscriptionName = customerSubscriptionName,
        registrationName = registrationName,
        resourceGroup = resourceGroup,
        tenantId = tenantId,
    )
}
