@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.inputs

import com.pulumi.azurenative.azurestack.inputs.GetLinkedSubscriptionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property linkedSubscriptionName Name of the Linked Subscription resource.
 * @property resourceGroup Name of the resource group.
 */
public data class GetLinkedSubscriptionPlainArgs(
    public val linkedSubscriptionName: String,
    public val resourceGroup: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestack.inputs.GetLinkedSubscriptionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestack.inputs.GetLinkedSubscriptionPlainArgs =
        com.pulumi.azurenative.azurestack.inputs.GetLinkedSubscriptionPlainArgs.builder()
            .linkedSubscriptionName(linkedSubscriptionName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLinkedSubscriptionPlainArgs].
 */
@PulumiTagMarker
public class GetLinkedSubscriptionPlainArgsBuilder internal constructor() {
    private var linkedSubscriptionName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value Name of the Linked Subscription resource.
     */
    @JvmName("ojdtvtghppmygnrq")
    public suspend fun linkedSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkedSubscriptionName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("birjfudqfbovsbhf")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): GetLinkedSubscriptionPlainArgs = GetLinkedSubscriptionPlainArgs(
        linkedSubscriptionName = linkedSubscriptionName ?: throw
            PulumiNullFieldException("linkedSubscriptionName"),
        resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
    )
}
