@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.ArcSettingArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ArcConnectivityPropertiesArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ArcConnectivityPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ArcSetting details.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-01-01-preview.
 * Other available API versions: 2021-09-01-preview, 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Create ArcSetting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var arcSetting = new AzureNative.AzureStackHCI.ArcSetting("arcSetting", new()
 *     {
 *         ArcSettingName = "default",
 *         ClusterName = "myCluster",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewArcSetting(ctx, "arcSetting", &azurestackhci.ArcSettingArgs{
 * 			ArcSettingName:    pulumi.String("default"),
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.ArcSetting;
 * import com.pulumi.azurenative.azurestackhci.ArcSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var arcSetting = new ArcSetting("arcSetting", ArcSettingArgs.builder()
 *             .arcSettingName("default")
 *             .clusterName("myCluster")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:ArcSetting myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/arcSettings/{arcSettingName}
 * ```
 * @property arcApplicationClientId App id of arc AAD identity.
 * @property arcApplicationObjectId Object id of arc AAD identity.
 * @property arcApplicationTenantId Tenant id of arc AAD identity.
 * @property arcInstanceResourceGroup The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
 * @property arcServicePrincipalObjectId Object id of arc AAD service principal.
 * @property arcSettingName The name of the proxy resource holding details of HCI ArcSetting information.
 * @property clusterName The name of the cluster.
 * @property connectivityProperties contains connectivity related configuration for ARC resources
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ArcSettingArgs(
    public val arcApplicationClientId: Output<String>? = null,
    public val arcApplicationObjectId: Output<String>? = null,
    public val arcApplicationTenantId: Output<String>? = null,
    public val arcInstanceResourceGroup: Output<String>? = null,
    public val arcServicePrincipalObjectId: Output<String>? = null,
    public val arcSettingName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val connectivityProperties: Output<List<ArcConnectivityPropertiesArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.ArcSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.ArcSettingArgs =
        com.pulumi.azurenative.azurestackhci.ArcSettingArgs.builder()
            .arcApplicationClientId(arcApplicationClientId?.applyValue({ args0 -> args0 }))
            .arcApplicationObjectId(arcApplicationObjectId?.applyValue({ args0 -> args0 }))
            .arcApplicationTenantId(arcApplicationTenantId?.applyValue({ args0 -> args0 }))
            .arcInstanceResourceGroup(arcInstanceResourceGroup?.applyValue({ args0 -> args0 }))
            .arcServicePrincipalObjectId(arcServicePrincipalObjectId?.applyValue({ args0 -> args0 }))
            .arcSettingName(arcSettingName?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .connectivityProperties(
                connectivityProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArcSettingArgs].
 */
@PulumiTagMarker
public class ArcSettingArgsBuilder internal constructor() {
    private var arcApplicationClientId: Output<String>? = null

    private var arcApplicationObjectId: Output<String>? = null

    private var arcApplicationTenantId: Output<String>? = null

    private var arcInstanceResourceGroup: Output<String>? = null

    private var arcServicePrincipalObjectId: Output<String>? = null

    private var arcSettingName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var connectivityProperties: Output<List<ArcConnectivityPropertiesArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value App id of arc AAD identity.
     */
    @JvmName("inhffkmqkvvdsbka")
    public suspend fun arcApplicationClientId(`value`: Output<String>) {
        this.arcApplicationClientId = value
    }

    /**
     * @param value Object id of arc AAD identity.
     */
    @JvmName("fyepvalqhunsfrlg")
    public suspend fun arcApplicationObjectId(`value`: Output<String>) {
        this.arcApplicationObjectId = value
    }

    /**
     * @param value Tenant id of arc AAD identity.
     */
    @JvmName("ojcqknqdcowhtnem")
    public suspend fun arcApplicationTenantId(`value`: Output<String>) {
        this.arcApplicationTenantId = value
    }

    /**
     * @param value The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
     */
    @JvmName("hsfmjgnrrseendbn")
    public suspend fun arcInstanceResourceGroup(`value`: Output<String>) {
        this.arcInstanceResourceGroup = value
    }

    /**
     * @param value Object id of arc AAD service principal.
     */
    @JvmName("oarvfxbcvhrcggxg")
    public suspend fun arcServicePrincipalObjectId(`value`: Output<String>) {
        this.arcServicePrincipalObjectId = value
    }

    /**
     * @param value The name of the proxy resource holding details of HCI ArcSetting information.
     */
    @JvmName("kcwpaxgwgabmhpks")
    public suspend fun arcSettingName(`value`: Output<String>) {
        this.arcSettingName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("nxxqbbodyeycrfgh")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value contains connectivity related configuration for ARC resources
     */
    @JvmName("vlqwavmgvdsojlbx")
    public suspend fun connectivityProperties(`value`: Output<List<ArcConnectivityPropertiesArgs>>) {
        this.connectivityProperties = value
    }

    @JvmName("tutjqsvfdjcquliw")
    public suspend fun connectivityProperties(vararg values: Output<ArcConnectivityPropertiesArgs>) {
        this.connectivityProperties = Output.all(values.asList())
    }

    /**
     * @param values contains connectivity related configuration for ARC resources
     */
    @JvmName("brgaosoyhmvjueiw")
    public suspend fun connectivityProperties(values: List<Output<ArcConnectivityPropertiesArgs>>) {
        this.connectivityProperties = Output.all(values)
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("juiadivtwbhpwtou")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value App id of arc AAD identity.
     */
    @JvmName("odybkdemewjrpiex")
    public suspend fun arcApplicationClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcApplicationClientId = mapped
    }

    /**
     * @param value Object id of arc AAD identity.
     */
    @JvmName("rvrtwvwofqobmadn")
    public suspend fun arcApplicationObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcApplicationObjectId = mapped
    }

    /**
     * @param value Tenant id of arc AAD identity.
     */
    @JvmName("lshpmvihcjhjrcuc")
    public suspend fun arcApplicationTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcApplicationTenantId = mapped
    }

    /**
     * @param value The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
     */
    @JvmName("jgoenbvwoaiwkurw")
    public suspend fun arcInstanceResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcInstanceResourceGroup = mapped
    }

    /**
     * @param value Object id of arc AAD service principal.
     */
    @JvmName("lqhtipqsrukfhixs")
    public suspend fun arcServicePrincipalObjectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcServicePrincipalObjectId = mapped
    }

    /**
     * @param value The name of the proxy resource holding details of HCI ArcSetting information.
     */
    @JvmName("tkwuvjtefwsgqsfm")
    public suspend fun arcSettingName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arcSettingName = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("eifrwnkedqfopfsk")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value contains connectivity related configuration for ARC resources
     */
    @JvmName("gmbcocvjjptljrpu")
    public suspend fun connectivityProperties(`value`: List<ArcConnectivityPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectivityProperties = mapped
    }

    /**
     * @param argument contains connectivity related configuration for ARC resources
     */
    @JvmName("dxwxepipunbvpeiq")
    public suspend
    fun connectivityProperties(argument: List<suspend ArcConnectivityPropertiesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ArcConnectivityPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectivityProperties = mapped
    }

    /**
     * @param argument contains connectivity related configuration for ARC resources
     */
    @JvmName("stgrdcvchqpnkxep")
    public suspend fun connectivityProperties(
        vararg
        argument: suspend ArcConnectivityPropertiesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ArcConnectivityPropertiesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.connectivityProperties = mapped
    }

    /**
     * @param argument contains connectivity related configuration for ARC resources
     */
    @JvmName("ryvseetuvwhdjpgq")
    public suspend
    fun connectivityProperties(argument: suspend ArcConnectivityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ArcConnectivityPropertiesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.connectivityProperties = mapped
    }

    /**
     * @param values contains connectivity related configuration for ARC resources
     */
    @JvmName("xpohnprpbbppqtuj")
    public suspend fun connectivityProperties(vararg values: ArcConnectivityPropertiesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectivityProperties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jlqurjoetyrtgvgt")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ArcSettingArgs = ArcSettingArgs(
        arcApplicationClientId = arcApplicationClientId,
        arcApplicationObjectId = arcApplicationObjectId,
        arcApplicationTenantId = arcApplicationTenantId,
        arcInstanceResourceGroup = arcInstanceResourceGroup,
        arcServicePrincipalObjectId = arcServicePrincipalObjectId,
        arcSettingName = arcSettingName,
        clusterName = clusterName,
        connectivityProperties = connectivityProperties,
        resourceGroupName = resourceGroupName,
    )
}
