@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GalleryImageIdentifierResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GalleryImageVersionResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.MarketplaceGalleryImageStatusResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GalleryImageIdentifierResponse.Companion.toKotlin as galleryImageIdentifierResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.GalleryImageVersionResponse.Companion.toKotlin as galleryImageVersionResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.MarketplaceGalleryImageStatusResponse.Companion.toKotlin as marketplaceGalleryImageStatusResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MarketplaceGalleryImage].
 */
@PulumiTagMarker
public class MarketplaceGalleryImageResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MarketplaceGalleryImageArgs = MarketplaceGalleryImageArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MarketplaceGalleryImageArgsBuilder.() -> Unit) {
        val builder = MarketplaceGalleryImageArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MarketplaceGalleryImage {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImage(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MarketplaceGalleryImage(builtJavaResource)
    }
}

/**
 * The marketplace gallery image resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
 * ## Example Usage
 * ### PutMarketplaceGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var marketplaceGalleryImage = new AzureNative.AzureStackHCI.MarketplaceGalleryImage("marketplaceGalleryImage", new()
 *     {
 *         CloudInitDataSource = "Azure",
 *         ContainerName = "Default_Container",
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HyperVGeneration = "V1",
 *         Identifier = new AzureNative.AzureStackHCI.Inputs.GalleryImageIdentifierArgs
 *         {
 *             Offer = "myOfferName",
 *             Publisher = "myPublisherName",
 *             Sku = "mySkuName",
 *         },
 *         Location = "West US2",
 *         MarketplaceGalleryImageName = "test-marketplace-gallery-image",
 *         OsType = AzureNative.AzureStackHCI.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "test-rg",
 *         Version = new AzureNative.AzureStackHCI.Inputs.GalleryImageVersionArgs
 *         {
 *             Name = "1.0.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewMarketplaceGalleryImage(ctx, "marketplaceGalleryImage", &azurestackhci.MarketplaceGalleryImageArgs{
 * 			CloudInitDataSource: pulumi.String("Azure"),
 * 			ContainerName:       pulumi.String("Default_Container"),
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HyperVGeneration: pulumi.String("V1"),
 * 			Identifier: &azurestackhci.GalleryImageIdentifierArgs{
 * 				Offer:     pulumi.String("myOfferName"),
 * 				Publisher: pulumi.String("myPublisherName"),
 * 				Sku:       pulumi.String("mySkuName"),
 * 			},
 * 			Location:                    pulumi.String("West US2"),
 * 			MarketplaceGalleryImageName: pulumi.String("test-marketplace-gallery-image"),
 * 			OsType:                      azurestackhci.OperatingSystemTypesWindows,
 * 			ResourceGroupName:           pulumi.String("test-rg"),
 * 			Version: &azurestackhci.GalleryImageVersionArgs{
 * 				Name: pulumi.String("1.0.0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImage;
 * import com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var marketplaceGalleryImage = new MarketplaceGalleryImage("marketplaceGalleryImage", MarketplaceGalleryImageArgs.builder()
 *             .cloudInitDataSource("Azure")
 *             .containerName("Default_Container")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hyperVGeneration("V1")
 *             .identifier(Map.ofEntries(
 *                 Map.entry("offer", "myOfferName"),
 *                 Map.entry("publisher", "myPublisherName"),
 *                 Map.entry("sku", "mySkuName")
 *             ))
 *             .location("West US2")
 *             .marketplaceGalleryImageName("test-marketplace-gallery-image")
 *             .osType("Windows")
 *             .resourceGroupName("test-rg")
 *             .version(Map.of("name", "1.0.0"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:MarketplaceGalleryImage test-marketplace-gallery-image /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/{marketplaceGalleryImageName}
 * ```
 */
public class MarketplaceGalleryImage internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImage,
) : KotlinCustomResource(javaResource, MarketplaceGalleryImageMapper) {
    /**
     * Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    public val cloudInitDataSource: Output<String>?
        get() = javaResource.cloudInitDataSource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Container Name for storage container
     */
    public val containerName: Output<String>?
        get() = javaResource.containerName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The hypervisor generation of the Virtual Machine [V1, V2]
     */
    public val hyperVGeneration: Output<String>?
        get() = javaResource.hyperVGeneration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the gallery image definition identifier.
     */
    public val identifier: Output<GalleryImageIdentifierResponse>?
        get() = javaResource.identifier().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    galleryImageIdentifierResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Operating system type that the gallery image uses [Windows, Linux]
     */
    public val osType: Output<String>?
        get() = javaResource.osType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Provisioning state of the marketplace gallery image.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The observed state of marketplace gallery images
     */
    public val status: Output<MarketplaceGalleryImageStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                marketplaceGalleryImageStatusResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies information about the gallery image version that you want to create or update.
     */
    public val version: Output<GalleryImageVersionResponse>?
        get() = javaResource.version().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    galleryImageVersionResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object MarketplaceGalleryImageMapper : ResourceMapper<MarketplaceGalleryImage> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImage::class == javaResource::class

    override fun map(javaResource: Resource): MarketplaceGalleryImage =
        MarketplaceGalleryImage(
            javaResource as
                com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImage,
        )
}

/**
 * @see [MarketplaceGalleryImage].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MarketplaceGalleryImage].
 */
public suspend fun marketplaceGalleryImage(
    name: String,
    block: suspend MarketplaceGalleryImageResourceBuilder.() -> Unit,
): MarketplaceGalleryImage {
    val builder = MarketplaceGalleryImageResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MarketplaceGalleryImage].
 * @param name The _unique_ name of the resulting resource.
 */
public fun marketplaceGalleryImage(name: String): MarketplaceGalleryImage {
    val builder = MarketplaceGalleryImageResourceBuilder()
    builder.name(name)
    return builder.build()
}
