@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.NetworkInterfaceArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.IPConfigurationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.IPConfigurationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.InterfaceDNSSettingsArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.InterfaceDNSSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The network interface resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
 * ## Example Usage
 * ### PutNetworkInterface
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var networkInterface = new AzureNative.AzureStackHCI.NetworkInterface("networkInterface", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         IpConfigurations = new[]
 *         {
 *             new AzureNative.AzureStackHCI.Inputs.IPConfigurationArgs
 *             {
 *                 Name = "ipconfig-sample",
 *                 Properties = new AzureNative.AzureStackHCI.Inputs.IPConfigurationPropertiesArgs
 *                 {
 *                     Subnet = new AzureNative.AzureStackHCI.Inputs.IPConfigurationSubnetArgs
 *                     {
 *                         Id = "test-vnet",
 *                     },
 *                 },
 *             },
 *         },
 *         Location = "West US2",
 *         NetworkInterfaceName = "test-nic",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewNetworkInterface(ctx, "networkInterface", &azurestackhci.NetworkInterfaceArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			IpConfigurations: []azurestackhci.IPConfigurationArgs{
 * 				{
 * 					Name: pulumi.String("ipconfig-sample"),
 * 					Properties: {
 * 						Subnet: {
 * 							Id: pulumi.String("test-vnet"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Location:             pulumi.String("West US2"),
 * 			NetworkInterfaceName: pulumi.String("test-nic"),
 * 			ResourceGroupName:    pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.NetworkInterface;
 * import com.pulumi.azurenative.azurestackhci.NetworkInterfaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var networkInterface = new NetworkInterface("networkInterface", NetworkInterfaceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .ipConfigurations(Map.ofEntries(
 *                 Map.entry("name", "ipconfig-sample"),
 *                 Map.entry("properties", Map.of("subnet", Map.of("id", "test-vnet")))
 *             ))
 *             .location("West US2")
 *             .networkInterfaceName("test-nic")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:NetworkInterface test-nic /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/networkInterfaces/{networkInterfaceName}
 * ```
 * @property dnsSettings DNS Settings for the interface
 * @property extendedLocation The extendedLocation of the resource.
 * @property ipConfigurations IPConfigurations - A list of IPConfigurations of the network interface.
 * @property location The geo-location where the resource lives
 * @property macAddress MacAddress - The MAC address of the network interface.
 * @property networkInterfaceName Name of the network interface
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class NetworkInterfaceArgs(
    public val dnsSettings: Output<InterfaceDNSSettingsArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val ipConfigurations: Output<List<IPConfigurationArgs>>? = null,
    public val location: Output<String>? = null,
    public val macAddress: Output<String>? = null,
    public val networkInterfaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.NetworkInterfaceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.NetworkInterfaceArgs =
        com.pulumi.azurenative.azurestackhci.NetworkInterfaceArgs.builder()
            .dnsSettings(dnsSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipConfigurations(
                ipConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .macAddress(macAddress?.applyValue({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [NetworkInterfaceArgs].
 */
@PulumiTagMarker
public class NetworkInterfaceArgsBuilder internal constructor() {
    private var dnsSettings: Output<InterfaceDNSSettingsArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var ipConfigurations: Output<List<IPConfigurationArgs>>? = null

    private var location: Output<String>? = null

    private var macAddress: Output<String>? = null

    private var networkInterfaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value DNS Settings for the interface
     */
    @JvmName("hfrkooeydwqethei")
    public suspend fun dnsSettings(`value`: Output<InterfaceDNSSettingsArgs>) {
        this.dnsSettings = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("vvrneogqlqbpdeyt")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value IPConfigurations - A list of IPConfigurations of the network interface.
     */
    @JvmName("xxvrawrjusfefxjk")
    public suspend fun ipConfigurations(`value`: Output<List<IPConfigurationArgs>>) {
        this.ipConfigurations = value
    }

    @JvmName("jdhcedciwqbtgnds")
    public suspend fun ipConfigurations(vararg values: Output<IPConfigurationArgs>) {
        this.ipConfigurations = Output.all(values.asList())
    }

    /**
     * @param values IPConfigurations - A list of IPConfigurations of the network interface.
     */
    @JvmName("yuhqyqcrlscewhjb")
    public suspend fun ipConfigurations(values: List<Output<IPConfigurationArgs>>) {
        this.ipConfigurations = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("axjjqttoucqjetgv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value MacAddress - The MAC address of the network interface.
     */
    @JvmName("rmjgyemmflakytyc")
    public suspend fun macAddress(`value`: Output<String>) {
        this.macAddress = value
    }

    /**
     * @param value Name of the network interface
     */
    @JvmName("fdsanccgsggvahqa")
    public suspend fun networkInterfaceName(`value`: Output<String>) {
        this.networkInterfaceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qdamxlnjmudlqmlu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("uowmsjvfbqhypmye")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value DNS Settings for the interface
     */
    @JvmName("ymutjlfuapfrryeh")
    public suspend fun dnsSettings(`value`: InterfaceDNSSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSettings = mapped
    }

    /**
     * @param argument DNS Settings for the interface
     */
    @JvmName("copgbspgwmvbbiri")
    public suspend fun dnsSettings(argument: suspend InterfaceDNSSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = InterfaceDNSSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dnsSettings = mapped
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("fxegxiyymusmmvsh")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("gtjqhdveqfswivah")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value IPConfigurations - A list of IPConfigurations of the network interface.
     */
    @JvmName("fwhydorfqgdvqwqs")
    public suspend fun ipConfigurations(`value`: List<IPConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IPConfigurations - A list of IPConfigurations of the network interface.
     */
    @JvmName("hvtmdmjephavvtgq")
    public suspend
    fun ipConfigurations(argument: List<suspend IPConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            IPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IPConfigurations - A list of IPConfigurations of the network interface.
     */
    @JvmName("ssbknixrjrfbumps")
    public suspend fun ipConfigurations(
        vararg
        argument: suspend IPConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            IPConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param argument IPConfigurations - A list of IPConfigurations of the network interface.
     */
    @JvmName("fpxeajwhksqnwbfb")
    public suspend fun ipConfigurations(argument: suspend IPConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipConfigurations = mapped
    }

    /**
     * @param values IPConfigurations - A list of IPConfigurations of the network interface.
     */
    @JvmName("rrtyshxtfeoshiva")
    public suspend fun ipConfigurations(vararg values: IPConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurations = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sieycrpcoiqipfop")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value MacAddress - The MAC address of the network interface.
     */
    @JvmName("ioqaflvjvigknbre")
    public suspend fun macAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.macAddress = mapped
    }

    /**
     * @param value Name of the network interface
     */
    @JvmName("fpygjnxmnsrvwttp")
    public suspend fun networkInterfaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("urtxybjloewcgwvq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aqjyuiekfhjpejom")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kjyotseecwagvnlv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): NetworkInterfaceArgs = NetworkInterfaceArgs(
        dnsSettings = dnsSettings,
        extendedLocation = extendedLocation,
        ipConfigurations = ipConfigurations,
        location = location,
        macAddress = macAddress,
        networkInterfaceName = networkInterfaceName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
