@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.StepResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.StepResponse.Companion.toKotlin as stepResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [UpdateRun].
 */
@PulumiTagMarker
public class UpdateRunResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UpdateRunArgs = UpdateRunArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UpdateRunArgsBuilder.() -> Unit) {
        val builder = UpdateRunArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): UpdateRun {
        val builtJavaResource = com.pulumi.azurenative.azurestackhci.UpdateRun(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UpdateRun(builtJavaResource)
    }
}

/**
 * Details of an Update run
 * Azure REST API version: 2023-03-01.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview, 2023-11-01-preview.
 * ## Example Usage
 * ### Get Update runs under cluster resource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var updateRun = new AzureNative.AzureStackHCI.UpdateRun("updateRun", new()
 *     {
 *         ClusterName = "testcluster",
 *         Description = "Update Azure Stack.",
 *         EndTimeUtc = "2022-04-06T13:58:42.969006+00:00",
 *         ErrorMessage = "",
 *         LastUpdatedTimeUtc = "2022-04-06T13:58:42.969006+00:00",
 *         Name = "Unnamed step",
 *         ResourceGroupName = "testrg",
 *         StartTimeUtc = "2022-04-06T01:36:33.3876751+00:00",
 *         Status = "Success",
 *         Steps = new[]
 *         {
 *             new AzureNative.AzureStackHCI.Inputs.StepArgs
 *             {
 *                 Description = "Prepare for SSU update",
 *                 EndTimeUtc = "2022-04-06T01:37:16.8728314+00:00",
 *                 ErrorMessage = "",
 *                 LastUpdatedTimeUtc = "2022-04-06T01:37:16.8728314+00:00",
 *                 Name = "PreUpdate Cloud",
 *                 StartTimeUtc = "2022-04-06T01:36:33.3876751+00:00",
 *                 Status = "Success",
 *                 Steps = new[] {},
 *             },
 *         },
 *         UpdateName = "Microsoft4.2203.2.32",
 *         UpdateRunName = "23b779ba-0d52-4a80-8571-45ca74664ec3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewUpdateRun(ctx, "updateRun", &azurestackhci.UpdateRunArgs{
 * 			ClusterName:        pulumi.String("testcluster"),
 * 			Description:        pulumi.String("Update Azure Stack."),
 * 			EndTimeUtc:         pulumi.String("2022-04-06T13:58:42.969006+00:00"),
 * 			ErrorMessage:       pulumi.String(""),
 * 			LastUpdatedTimeUtc: pulumi.String("2022-04-06T13:58:42.969006+00:00"),
 * 			Name:               pulumi.String("Unnamed step"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			StartTimeUtc:       pulumi.String("2022-04-06T01:36:33.3876751+00:00"),
 * 			Status:             pulumi.String("Success"),
 * 			Steps: []azurestackhci.StepArgs{
 * 				{
 * 					Description:        pulumi.String("Prepare for SSU update"),
 * 					EndTimeUtc:         pulumi.String("2022-04-06T01:37:16.8728314+00:00"),
 * 					ErrorMessage:       pulumi.String(""),
 * 					LastUpdatedTimeUtc: pulumi.String("2022-04-06T01:37:16.8728314+00:00"),
 * 					Name:               pulumi.String("PreUpdate Cloud"),
 * 					StartTimeUtc:       pulumi.String("2022-04-06T01:36:33.3876751+00:00"),
 * 					Status:             pulumi.String("Success"),
 * 					Steps:              azurestackhci.StepArray{},
 * 				},
 * 			},
 * 			UpdateName:    pulumi.String("Microsoft4.2203.2.32"),
 * 			UpdateRunName: pulumi.String("23b779ba-0d52-4a80-8571-45ca74664ec3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.UpdateRun;
 * import com.pulumi.azurenative.azurestackhci.UpdateRunArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var updateRun = new UpdateRun("updateRun", UpdateRunArgs.builder()
 *             .clusterName("testcluster")
 *             .description("Update Azure Stack.")
 *             .endTimeUtc("2022-04-06T13:58:42.969006+00:00")
 *             .errorMessage("")
 *             .lastUpdatedTimeUtc("2022-04-06T13:58:42.969006+00:00")
 *             .name("Unnamed step")
 *             .resourceGroupName("testrg")
 *             .startTimeUtc("2022-04-06T01:36:33.3876751+00:00")
 *             .status("Success")
 *             .steps(Map.ofEntries(
 *                 Map.entry("description", "Prepare for SSU update"),
 *                 Map.entry("endTimeUtc", "2022-04-06T01:37:16.8728314+00:00"),
 *                 Map.entry("errorMessage", ""),
 *                 Map.entry("lastUpdatedTimeUtc", "2022-04-06T01:37:16.8728314+00:00"),
 *                 Map.entry("name", "PreUpdate Cloud"),
 *                 Map.entry("startTimeUtc", "2022-04-06T01:36:33.3876751+00:00"),
 *                 Map.entry("status", "Success"),
 *                 Map.entry("steps", )
 *             ))
 *             .updateName("Microsoft4.2203.2.32")
 *             .updateRunName("23b779ba-0d52-4a80-8571-45ca74664ec3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:UpdateRun Microsoft4.2203.2.32/23b779ba-0d52-4a80-8571-45ca74664ec3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}/updateRuns/{updateRunName}
 * ```
 */
public class UpdateRun internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.UpdateRun,
) : KotlinCustomResource(javaResource, UpdateRunMapper) {
    /**
     * More detailed description of the step.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Duration of the update run.
     */
    public val duration: Output<String>?
        get() = javaResource.duration().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * When the step reached a terminal state.
     */
    public val endTimeUtc: Output<String>?
        get() = javaResource.endTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Error message, specified if the step is in a failed state.
     */
    public val errorMessage: Output<String>?
        get() = javaResource.errorMessage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Timestamp of the most recently completed step in the update run.
     */
    public val lastUpdatedTime: Output<String>?
        get() = javaResource.lastUpdatedTime().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Completion time of this step or the last completed sub-step.
     */
    public val lastUpdatedTimeUtc: Output<String>?
        get() = javaResource.lastUpdatedTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state of the UpdateRuns proxy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * When the step started, or empty if it has not started executing.
     */
    public val startTimeUtc: Output<String>?
        get() = javaResource.startTimeUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * State of the update run.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Recursive model for child steps of this step.
     */
    public val steps: Output<List<StepResponse>>?
        get() = javaResource.steps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> stepResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Timestamp of the update run was started.
     */
    public val timeStarted: Output<String>?
        get() = javaResource.timeStarted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object UpdateRunMapper : ResourceMapper<UpdateRun> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.UpdateRun::class == javaResource::class

    override fun map(javaResource: Resource): UpdateRun = UpdateRun(
        javaResource as
            com.pulumi.azurenative.azurestackhci.UpdateRun,
    )
}

/**
 * @see [UpdateRun].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UpdateRun].
 */
public suspend fun updateRun(name: String, block: suspend UpdateRunResourceBuilder.() -> Unit):
    UpdateRun {
    val builder = UpdateRunResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UpdateRun].
 * @param name The _unique_ name of the resulting resource.
 */
public fun updateRun(name: String): UpdateRun {
    val builder = UpdateRunResourceBuilder()
    builder.name(name)
    return builder.build()
}
