@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseDhcpOptions
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseSubnets
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkStatusResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseDhcpOptions.Companion.toKotlin as virtualNetworkPropertiesResponseDhcpOptionsToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkPropertiesResponseSubnets.Companion.toKotlin as virtualNetworkPropertiesResponseSubnetsToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.VirtualNetworkStatusResponse.Companion.toKotlin as virtualNetworkStatusResponseToKotlin

/**
 * Builder for [VirtualNetwork].
 */
@PulumiTagMarker
public class VirtualNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VirtualNetworkArgs = VirtualNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VirtualNetworkArgsBuilder.() -> Unit) {
        val builder = VirtualNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): VirtualNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.azurestackhci.VirtualNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return VirtualNetwork(builtJavaResource)
    }
}

/**
 * The virtual network resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview.
 * ## Example Usage
 * ### PutVirtualNetwork
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var virtualNetwork = new AzureNative.AzureStackHCI.VirtualNetwork("virtualNetwork", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West US2",
 *         NetworkType = "Transparent",
 *         ResourceGroupName = "test-rg",
 *         VirtualNetworkName = "test-vnet",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewVirtualNetwork(ctx, "virtualNetwork", &azurestackhci.VirtualNetworkArgs{
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:           pulumi.String("West US2"),
 * 			NetworkType:        pulumi.String("Transparent"),
 * 			ResourceGroupName:  pulumi.String("test-rg"),
 * 			VirtualNetworkName: pulumi.String("test-vnet"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.VirtualNetwork;
 * import com.pulumi.azurenative.azurestackhci.VirtualNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var virtualNetwork = new VirtualNetwork("virtualNetwork", VirtualNetworkArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West US2")
 *             .networkType("Transparent")
 *             .resourceGroupName("test-rg")
 *             .virtualNetworkName("test-vnet")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:VirtualNetwork test-vnet /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/virtualNetworks/{virtualNetworkName}
 * ```
 */
public class VirtualNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.VirtualNetwork,
) : KotlinCustomResource(javaResource, VirtualNetworkMapper) {
    /**
     * DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network. Standard DHCP option for a subnet overrides VNET DHCP options.
     */
    public val dhcpOptions: Output<VirtualNetworkPropertiesResponseDhcpOptions>?
        get() = javaResource.dhcpOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    virtualNetworkPropertiesResponseDhcpOptionsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The extendedLocation of the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> extendedLocationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Type of the network
     */
    public val networkType: Output<String>?
        get() = javaResource.networkType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the virtual network.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The observed state of virtual networks
     */
    public val status: Output<VirtualNetworkStatusResponse>
        get() = javaResource.status().applyValue({ args0 ->
            args0.let({ args0 ->
                virtualNetworkStatusResponseToKotlin(args0)
            })
        })

    /**
     * Subnet - list of subnets under the virtual network
     */
    public val subnets: Output<List<VirtualNetworkPropertiesResponseSubnets>>?
        get() = javaResource.subnets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        virtualNetworkPropertiesResponseSubnetsToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * name of the network switch to be used for VMs
     */
    public val vmSwitchName: Output<String>?
        get() = javaResource.vmSwitchName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object VirtualNetworkMapper : ResourceMapper<VirtualNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.VirtualNetwork::class == javaResource::class

    override fun map(javaResource: Resource): VirtualNetwork = VirtualNetwork(
        javaResource as
            com.pulumi.azurenative.azurestackhci.VirtualNetwork,
    )
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VirtualNetwork].
 */
public suspend fun virtualNetwork(
    name: String,
    block: suspend VirtualNetworkResourceBuilder.() -> Unit,
): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VirtualNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun virtualNetwork(name: String): VirtualNetwork {
    val builder = VirtualNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
