@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The deployment mode for cluster deployment.
 */
public enum class DeploymentMode(
    public val javaValue: com.pulumi.azurenative.azurestackhci.enums.DeploymentMode,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.enums.DeploymentMode> {
    /**
     * Validate deployment settings for cluster.
     */
    Validate(com.pulumi.azurenative.azurestackhci.enums.DeploymentMode.Validate),

    /**
     * Deploy cluster using deployment settings.
     */
    Deploy(com.pulumi.azurenative.azurestackhci.enums.DeploymentMode.Deploy),
    ;

    override fun toJava(): com.pulumi.azurenative.azurestackhci.enums.DeploymentMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.enums.DeploymentMode):
            DeploymentMode = DeploymentMode.values().first { it.javaValue == javaType }
    }
}
