@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.ArcConnectivityPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Connectivity related configuration required by arc server.
 * @property enabled True indicates ARC connectivity is enabled
 */
public data class ArcConnectivityPropertiesArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.ArcConnectivityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.ArcConnectivityPropertiesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.ArcConnectivityPropertiesArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ArcConnectivityPropertiesArgs].
 */
@PulumiTagMarker
public class ArcConnectivityPropertiesArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value True indicates ARC connectivity is enabled
     */
    @JvmName("jmuegupjvpyshqft")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value True indicates ARC connectivity is enabled
     */
    @JvmName("rimlurchgxvfavou")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ArcConnectivityPropertiesArgs = ArcConnectivityPropertiesArgs(
        enabled = enabled,
    )
}
