@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.DeploymentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Deployment Configuration
 * @property scaleUnits Scale units will contains list of deployment data
 * @property version deployment template version
 */
public data class DeploymentConfigurationArgs(
    public val scaleUnits: Output<List<ScaleUnitsArgs>>,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.DeploymentConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.DeploymentConfigurationArgs =
        com.pulumi.azurenative.azurestackhci.inputs.DeploymentConfigurationArgs.builder()
            .scaleUnits(
                scaleUnits.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentConfigurationArgs].
 */
@PulumiTagMarker
public class DeploymentConfigurationArgsBuilder internal constructor() {
    private var scaleUnits: Output<List<ScaleUnitsArgs>>? = null

    private var version: Output<String>? = null

    /**
     * @param value Scale units will contains list of deployment data
     */
    @JvmName("nahifxdfoicdmpgr")
    public suspend fun scaleUnits(`value`: Output<List<ScaleUnitsArgs>>) {
        this.scaleUnits = value
    }

    @JvmName("frxukgmimuspygdg")
    public suspend fun scaleUnits(vararg values: Output<ScaleUnitsArgs>) {
        this.scaleUnits = Output.all(values.asList())
    }

    /**
     * @param values Scale units will contains list of deployment data
     */
    @JvmName("bxlcwfqdoxnineot")
    public suspend fun scaleUnits(values: List<Output<ScaleUnitsArgs>>) {
        this.scaleUnits = Output.all(values)
    }

    /**
     * @param value deployment template version
     */
    @JvmName("tiwvvnbbpsdfhrfx")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Scale units will contains list of deployment data
     */
    @JvmName("oyejrapaqwxhtxfr")
    public suspend fun scaleUnits(`value`: List<ScaleUnitsArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleUnits = mapped
    }

    /**
     * @param argument Scale units will contains list of deployment data
     */
    @JvmName("byreqqtbivjdonon")
    public suspend fun scaleUnits(argument: List<suspend ScaleUnitsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ScaleUnitsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.scaleUnits = mapped
    }

    /**
     * @param argument Scale units will contains list of deployment data
     */
    @JvmName("hdqqccuxxvleolpl")
    public suspend fun scaleUnits(vararg argument: suspend ScaleUnitsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ScaleUnitsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.scaleUnits = mapped
    }

    /**
     * @param argument Scale units will contains list of deployment data
     */
    @JvmName("luvqudnsrkxlkqmi")
    public suspend fun scaleUnits(argument: suspend ScaleUnitsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScaleUnitsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scaleUnits = mapped
    }

    /**
     * @param values Scale units will contains list of deployment data
     */
    @JvmName("quqckkoydxklfppl")
    public suspend fun scaleUnits(vararg values: ScaleUnitsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleUnits = mapped
    }

    /**
     * @param value deployment template version
     */
    @JvmName("cwggdresylyxqgwy")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): DeploymentConfigurationArgs = DeploymentConfigurationArgs(
        scaleUnits = scaleUnits ?: throw PulumiNullFieldException("scaleUnits"),
        version = version,
    )
}
