@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.DeviceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The device Configuration of a device.
 * @property deviceMetadata device metadata details.
 * @property nicDetails NIC Details of device
 */
public data class DeviceConfigurationArgs(
    public val deviceMetadata: Output<String>? = null,
    public val nicDetails: Output<List<NicDetailArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.DeviceConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.DeviceConfigurationArgs =
        com.pulumi.azurenative.azurestackhci.inputs.DeviceConfigurationArgs.builder()
            .deviceMetadata(deviceMetadata?.applyValue({ args0 -> args0 }))
            .nicDetails(
                nicDetails.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeviceConfigurationArgs].
 */
@PulumiTagMarker
public class DeviceConfigurationArgsBuilder internal constructor() {
    private var deviceMetadata: Output<String>? = null

    private var nicDetails: Output<List<NicDetailArgs>>? = null

    /**
     * @param value device metadata details.
     */
    @JvmName("qlddrymtrnoceuha")
    public suspend fun deviceMetadata(`value`: Output<String>) {
        this.deviceMetadata = value
    }

    /**
     * @param value NIC Details of device
     */
    @JvmName("dmgqanyqcnfclwfu")
    public suspend fun nicDetails(`value`: Output<List<NicDetailArgs>>) {
        this.nicDetails = value
    }

    @JvmName("pxwkialogtxfllai")
    public suspend fun nicDetails(vararg values: Output<NicDetailArgs>) {
        this.nicDetails = Output.all(values.asList())
    }

    /**
     * @param values NIC Details of device
     */
    @JvmName("hwgohckeqytfgdud")
    public suspend fun nicDetails(values: List<Output<NicDetailArgs>>) {
        this.nicDetails = Output.all(values)
    }

    /**
     * @param value device metadata details.
     */
    @JvmName("rorajmmnlqsvfdok")
    public suspend fun deviceMetadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceMetadata = mapped
    }

    /**
     * @param value NIC Details of device
     */
    @JvmName("wdnckcxtkitvahlb")
    public suspend fun nicDetails(`value`: List<NicDetailArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicDetails = mapped
    }

    /**
     * @param argument NIC Details of device
     */
    @JvmName("anjpumntsnhvhgpy")
    public suspend fun nicDetails(argument: List<suspend NicDetailArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { NicDetailArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.nicDetails = mapped
    }

    /**
     * @param argument NIC Details of device
     */
    @JvmName("cijcdfhrjtljggmn")
    public suspend fun nicDetails(vararg argument: suspend NicDetailArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { NicDetailArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.nicDetails = mapped
    }

    /**
     * @param argument NIC Details of device
     */
    @JvmName("njnwdktvpwdlwroi")
    public suspend fun nicDetails(argument: suspend NicDetailArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NicDetailArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.nicDetails = mapped
    }

    /**
     * @param values NIC Details of device
     */
    @JvmName("yrvwbgxgliqnvrtb")
    public suspend fun nicDetails(vararg values: NicDetailArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nicDetails = mapped
    }

    internal fun build(): DeviceConfigurationArgs = DeviceConfigurationArgs(
        deviceMetadata = deviceMetadata,
        nicDetails = nicDetails ?: throw PulumiNullFieldException("nicDetails"),
    )
}
