@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GalleryImageVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Specifies information about the gallery image version that you want to create or update.
 * @property name This is the version of the gallery image.
 */
public data class GalleryImageVersionArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GalleryImageVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GalleryImageVersionArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GalleryImageVersionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GalleryImageVersionArgs].
 */
@PulumiTagMarker
public class GalleryImageVersionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value This is the version of the gallery image.
     */
    @JvmName("bdyqtcswcckkaiah")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value This is the version of the gallery image.
     */
    @JvmName("twdaeuhguydeeima")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GalleryImageVersionArgs = GalleryImageVersionArgs(
        name = name,
    )
}
