@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetDeploymentSettingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster.
 * @property deploymentSettingsName Name of Deployment Setting
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDeploymentSettingPlainArgs(
    public val clusterName: String,
    public val deploymentSettingsName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetDeploymentSettingPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetDeploymentSettingPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetDeploymentSettingPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .deploymentSettingsName(deploymentSettingsName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDeploymentSettingPlainArgs].
 */
@PulumiTagMarker
public class GetDeploymentSettingPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var deploymentSettingsName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("lptfrmptyfjmgwjy")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value Name of Deployment Setting
     */
    @JvmName("aqitppjtcsosewgk")
    public suspend fun deploymentSettingsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deploymentSettingsName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nxkulqyrwauxiceq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDeploymentSettingPlainArgs = GetDeploymentSettingPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        deploymentSettingsName = deploymentSettingsName ?: throw
            PulumiNullFieldException("deploymentSettingsName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
