@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetGalleryImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property galleryImageName Name of the gallery image
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetGalleryImagePlainArgs(
    public val galleryImageName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetGalleryImagePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetGalleryImagePlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetGalleryImagePlainArgs.builder()
            .galleryImageName(galleryImageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGalleryImagePlainArgs].
 */
@PulumiTagMarker
public class GetGalleryImagePlainArgsBuilder internal constructor() {
    private var galleryImageName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the gallery image
     */
    @JvmName("rphrrpudsjhtluhb")
    public suspend fun galleryImageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.galleryImageName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gqrlblkxncihyuwr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGalleryImagePlainArgs = GetGalleryImagePlainArgs(
        galleryImageName = galleryImageName ?: throw PulumiNullFieldException("galleryImageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
