@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetMarketplaceGalleryImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property marketplaceGalleryImageName Name of the marketplace gallery image
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetMarketplaceGalleryImagePlainArgs(
    public val marketplaceGalleryImageName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetMarketplaceGalleryImagePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.GetMarketplaceGalleryImagePlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetMarketplaceGalleryImagePlainArgs.builder()
            .marketplaceGalleryImageName(marketplaceGalleryImageName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMarketplaceGalleryImagePlainArgs].
 */
@PulumiTagMarker
public class GetMarketplaceGalleryImagePlainArgsBuilder internal constructor() {
    private var marketplaceGalleryImageName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the marketplace gallery image
     */
    @JvmName("mdinhxseqemtkhqy")
    public suspend fun marketplaceGalleryImageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.marketplaceGalleryImageName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pmueltbcxdxwawhi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMarketplaceGalleryImagePlainArgs = GetMarketplaceGalleryImagePlainArgs(
        marketplaceGalleryImageName = marketplaceGalleryImageName ?: throw
            PulumiNullFieldException("marketplaceGalleryImageName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
