@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetUpdatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property updateName The name of the Update
 */
public data class GetUpdatePlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
    public val updateName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetUpdatePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetUpdatePlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetUpdatePlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .updateName(updateName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUpdatePlainArgs].
 */
@PulumiTagMarker
public class GetUpdatePlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    private var updateName: String? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("fvdplqqblbhwxuik")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lrvkuqngqswoqnix")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Update
     */
    @JvmName("vclfsnkkxbdnffha")
    public suspend fun updateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.updateName = mapped
    }

    internal fun build(): GetUpdatePlainArgs = GetUpdatePlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        updateName = updateName ?: throw PulumiNullFieldException("updateName"),
    )
}
