@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.GetUpdateRunPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property clusterName The name of the cluster.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property updateName The name of the Update
 * @property updateRunName The name of the Update Run
 */
public data class GetUpdateRunPlainArgs(
    public val clusterName: String,
    public val resourceGroupName: String,
    public val updateName: String,
    public val updateRunName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.GetUpdateRunPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.GetUpdateRunPlainArgs =
        com.pulumi.azurenative.azurestackhci.inputs.GetUpdateRunPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .updateName(updateName.let({ args0 -> args0 }))
            .updateRunName(updateRunName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetUpdateRunPlainArgs].
 */
@PulumiTagMarker
public class GetUpdateRunPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var resourceGroupName: String? = null

    private var updateName: String? = null

    private var updateRunName: String? = null

    /**
     * @param value The name of the cluster.
     */
    @JvmName("kgucyygnfemmivft")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ybtpvsiidjyrqcot")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Update
     */
    @JvmName("cqlwjspjjmtqhtym")
    public suspend fun updateName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.updateName = mapped
    }

    /**
     * @param value The name of the Update Run
     */
    @JvmName("bvqbjricxvdjppin")
    public suspend fun updateRunName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.updateRunName = mapped
    }

    internal fun build(): GetUpdateRunPlainArgs = GetUpdateRunPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        updateName = updateName ?: throw PulumiNullFieldException("updateName"),
        updateRunName = updateRunName ?: throw PulumiNullFieldException("updateRunName"),
    )
}
