@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationSubnetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Subnet - Name of Subnet bound to the IP configuration.
 * @property id ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
 */
public data class IPConfigurationSubnetArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationSubnetArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationSubnetArgs =
        com.pulumi.azurenative.azurestackhci.inputs.IPConfigurationSubnetArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPConfigurationSubnetArgs].
 */
@PulumiTagMarker
public class IPConfigurationSubnetArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
     */
    @JvmName("xbwijrcjyujxhxep")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value ID - The ARM resource id in the form of /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
     */
    @JvmName("qdifscutchdcbkwp")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): IPConfigurationSubnetArgs = IPConfigurationSubnetArgs(
        id = id,
    )
}
