@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.IPPoolArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.IPPoolTypeEnum
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property end end of the ip address pool
 * @property ipPoolType ip pool type
 * @property name Name of the IP-Pool
 * @property start start of the ip address pool
 */
public data class IPPoolArgs(
    public val end: Output<String>? = null,
    public val ipPoolType: Output<IPPoolTypeEnum>? = null,
    public val name: Output<String>? = null,
    public val start: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.IPPoolArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.IPPoolArgs =
        com.pulumi.azurenative.azurestackhci.inputs.IPPoolArgs.builder()
            .end(end?.applyValue({ args0 -> args0 }))
            .ipPoolType(ipPoolType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .start(start?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPPoolArgs].
 */
@PulumiTagMarker
public class IPPoolArgsBuilder internal constructor() {
    private var end: Output<String>? = null

    private var ipPoolType: Output<IPPoolTypeEnum>? = null

    private var name: Output<String>? = null

    private var start: Output<String>? = null

    /**
     * @param value end of the ip address pool
     */
    @JvmName("tqwxgintyxonjqxr")
    public suspend fun end(`value`: Output<String>) {
        this.end = value
    }

    /**
     * @param value ip pool type
     */
    @JvmName("tbqnwwmxipuhorit")
    public suspend fun ipPoolType(`value`: Output<IPPoolTypeEnum>) {
        this.ipPoolType = value
    }

    /**
     * @param value Name of the IP-Pool
     */
    @JvmName("uivmcmysbgihbrgq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value start of the ip address pool
     */
    @JvmName("ausjaqnvaohxmedj")
    public suspend fun start(`value`: Output<String>) {
        this.start = value
    }

    /**
     * @param value end of the ip address pool
     */
    @JvmName("hotodtexmoatyatg")
    public suspend fun end(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.end = mapped
    }

    /**
     * @param value ip pool type
     */
    @JvmName("etcpsfxpqlffvnrn")
    public suspend fun ipPoolType(`value`: IPPoolTypeEnum?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPoolType = mapped
    }

    /**
     * @param value Name of the IP-Pool
     */
    @JvmName("urvnkbkhnmljcmde")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value start of the ip address pool
     */
    @JvmName("rbgvccqeuivmqkmh")
    public suspend fun start(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.start = mapped
    }

    internal fun build(): IPPoolArgs = IPPoolArgs(
        end = end,
        ipPoolType = ipPoolType,
        name = name,
        start = start,
    )
}
