@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.InfrastructureNetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The InfrastructureNetwork of a AzureStackHCI Cluster.
 * @property dnsServers IPv4 address of the DNS servers in your environment.
 * @property gateway Default gateway that should be used for the provided IP address space.
 * @property ipPools Range of IP addresses from which addresses are allocated for nodes within a subnet.
 * @property subnetMask Subnet mask that matches the provided IP address space.
 * @property useDhcp Allows customers to use DHCP for Hosts and Cluster IPs. If not declared, the deployment will default to static IPs. When true, GW and DNS servers are not required
 */
public data class InfrastructureNetworkArgs(
    public val dnsServers: Output<List<String>>? = null,
    public val gateway: Output<String>? = null,
    public val ipPools: Output<List<IpPoolsArgs>>? = null,
    public val subnetMask: Output<String>? = null,
    public val useDhcp: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.InfrastructureNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.InfrastructureNetworkArgs =
        com.pulumi.azurenative.azurestackhci.inputs.InfrastructureNetworkArgs.builder()
            .dnsServers(dnsServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .gateway(gateway?.applyValue({ args0 -> args0 }))
            .ipPools(
                ipPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnetMask(subnetMask?.applyValue({ args0 -> args0 }))
            .useDhcp(useDhcp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InfrastructureNetworkArgs].
 */
@PulumiTagMarker
public class InfrastructureNetworkArgsBuilder internal constructor() {
    private var dnsServers: Output<List<String>>? = null

    private var gateway: Output<String>? = null

    private var ipPools: Output<List<IpPoolsArgs>>? = null

    private var subnetMask: Output<String>? = null

    private var useDhcp: Output<Boolean>? = null

    /**
     * @param value IPv4 address of the DNS servers in your environment.
     */
    @JvmName("cbvnswddcmnasscy")
    public suspend fun dnsServers(`value`: Output<List<String>>) {
        this.dnsServers = value
    }

    @JvmName("xickewvmjkrquvlj")
    public suspend fun dnsServers(vararg values: Output<String>) {
        this.dnsServers = Output.all(values.asList())
    }

    /**
     * @param values IPv4 address of the DNS servers in your environment.
     */
    @JvmName("cbbhjkslrphlbfjk")
    public suspend fun dnsServers(values: List<Output<String>>) {
        this.dnsServers = Output.all(values)
    }

    /**
     * @param value Default gateway that should be used for the provided IP address space.
     */
    @JvmName("axkyysqjbesejaaj")
    public suspend fun gateway(`value`: Output<String>) {
        this.gateway = value
    }

    /**
     * @param value Range of IP addresses from which addresses are allocated for nodes within a subnet.
     */
    @JvmName("tyuicfsghhrimahk")
    public suspend fun ipPools(`value`: Output<List<IpPoolsArgs>>) {
        this.ipPools = value
    }

    @JvmName("juidrigpmjatbxvn")
    public suspend fun ipPools(vararg values: Output<IpPoolsArgs>) {
        this.ipPools = Output.all(values.asList())
    }

    /**
     * @param values Range of IP addresses from which addresses are allocated for nodes within a subnet.
     */
    @JvmName("ectigikeenpbrdbe")
    public suspend fun ipPools(values: List<Output<IpPoolsArgs>>) {
        this.ipPools = Output.all(values)
    }

    /**
     * @param value Subnet mask that matches the provided IP address space.
     */
    @JvmName("kcfctxscwodnrdqi")
    public suspend fun subnetMask(`value`: Output<String>) {
        this.subnetMask = value
    }

    /**
     * @param value Allows customers to use DHCP for Hosts and Cluster IPs. If not declared, the deployment will default to static IPs. When true, GW and DNS servers are not required
     */
    @JvmName("pteodtiuwwifsiie")
    public suspend fun useDhcp(`value`: Output<Boolean>) {
        this.useDhcp = value
    }

    /**
     * @param value IPv4 address of the DNS servers in your environment.
     */
    @JvmName("tsucnavmqijvirwy")
    public suspend fun dnsServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param values IPv4 address of the DNS servers in your environment.
     */
    @JvmName("oilqxhcrnuxkwyvh")
    public suspend fun dnsServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsServers = mapped
    }

    /**
     * @param value Default gateway that should be used for the provided IP address space.
     */
    @JvmName("uacopvpxowingmja")
    public suspend fun gateway(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gateway = mapped
    }

    /**
     * @param value Range of IP addresses from which addresses are allocated for nodes within a subnet.
     */
    @JvmName("elwhmwlwjnbimjkl")
    public suspend fun ipPools(`value`: List<IpPoolsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPools = mapped
    }

    /**
     * @param argument Range of IP addresses from which addresses are allocated for nodes within a subnet.
     */
    @JvmName("kqddeaykbblmujem")
    public suspend fun ipPools(argument: List<suspend IpPoolsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpPoolsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param argument Range of IP addresses from which addresses are allocated for nodes within a subnet.
     */
    @JvmName("rtqviphqvdrauyyv")
    public suspend fun ipPools(vararg argument: suspend IpPoolsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpPoolsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param argument Range of IP addresses from which addresses are allocated for nodes within a subnet.
     */
    @JvmName("befdgadululmvrkq")
    public suspend fun ipPools(argument: suspend IpPoolsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpPoolsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param values Range of IP addresses from which addresses are allocated for nodes within a subnet.
     */
    @JvmName("imqcmqsfmmsmouwb")
    public suspend fun ipPools(vararg values: IpPoolsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipPools = mapped
    }

    /**
     * @param value Subnet mask that matches the provided IP address space.
     */
    @JvmName("phxpgksvdqrvtofe")
    public suspend fun subnetMask(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetMask = mapped
    }

    /**
     * @param value Allows customers to use DHCP for Hosts and Cluster IPs. If not declared, the deployment will default to static IPs. When true, GW and DNS servers are not required
     */
    @JvmName("uncwuimstrqvcmfu")
    public suspend fun useDhcp(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useDhcp = mapped
    }

    internal fun build(): InfrastructureNetworkArgs = InfrastructureNetworkArgs(
        dnsServers = dnsServers,
        gateway = gateway,
        ipPools = ipPools,
        subnetMask = subnetMask,
        useDhcp = useDhcp,
    )
}
