@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.ObservabilityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Observability of AzureStackHCI Cluster.
 * @property episodicDataUpload When set to true, collects log data to facilitate quicker issue resolution.
 * @property euLocation Location of your cluster. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to false results in all data sent to Microsoft to be stored outside of the EU.
 * @property streamingDataClient Enables telemetry data to be sent to Microsoft
 */
public data class ObservabilityArgs(
    public val episodicDataUpload: Output<Boolean>? = null,
    public val euLocation: Output<Boolean>? = null,
    public val streamingDataClient: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.ObservabilityArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.ObservabilityArgs =
        com.pulumi.azurenative.azurestackhci.inputs.ObservabilityArgs.builder()
            .episodicDataUpload(episodicDataUpload?.applyValue({ args0 -> args0 }))
            .euLocation(euLocation?.applyValue({ args0 -> args0 }))
            .streamingDataClient(streamingDataClient?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObservabilityArgs].
 */
@PulumiTagMarker
public class ObservabilityArgsBuilder internal constructor() {
    private var episodicDataUpload: Output<Boolean>? = null

    private var euLocation: Output<Boolean>? = null

    private var streamingDataClient: Output<Boolean>? = null

    /**
     * @param value When set to true, collects log data to facilitate quicker issue resolution.
     */
    @JvmName("rqjckufilfqnsjpn")
    public suspend fun episodicDataUpload(`value`: Output<Boolean>) {
        this.episodicDataUpload = value
    }

    /**
     * @param value Location of your cluster. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to false results in all data sent to Microsoft to be stored outside of the EU.
     */
    @JvmName("vxvjxfmqoaixpfft")
    public suspend fun euLocation(`value`: Output<Boolean>) {
        this.euLocation = value
    }

    /**
     * @param value Enables telemetry data to be sent to Microsoft
     */
    @JvmName("rdvlrkaxcqbxqtfw")
    public suspend fun streamingDataClient(`value`: Output<Boolean>) {
        this.streamingDataClient = value
    }

    /**
     * @param value When set to true, collects log data to facilitate quicker issue resolution.
     */
    @JvmName("ieqestdwtxjjffqi")
    public suspend fun episodicDataUpload(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.episodicDataUpload = mapped
    }

    /**
     * @param value Location of your cluster. The log and diagnostic data is sent to the appropriate diagnostics servers depending upon where your cluster resides. Setting this to false results in all data sent to Microsoft to be stored outside of the EU.
     */
    @JvmName("gioffpkncswvnmvo")
    public suspend fun euLocation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.euLocation = mapped
    }

    /**
     * @param value Enables telemetry data to be sent to Microsoft
     */
    @JvmName("yqitgvwvikypoojq")
    public suspend fun streamingDataClient(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingDataClient = mapped
    }

    internal fun build(): ObservabilityArgs = ObservabilityArgs(
        episodicDataUpload = episodicDataUpload,
        euLocation = euLocation,
        streamingDataClient = streamingDataClient,
    )
}
