@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.RouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Route table resource.
 * @property routes Collection of routes contained within a route table.
 */
public data class RouteTableArgs(
    public val routes: Output<List<RouteArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.RouteTableArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.RouteTableArgs =
        com.pulumi.azurenative.azurestackhci.inputs.RouteTableArgs.builder()
            .routes(
                routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RouteTableArgs].
 */
@PulumiTagMarker
public class RouteTableArgsBuilder internal constructor() {
    private var routes: Output<List<RouteArgs>>? = null

    /**
     * @param value Collection of routes contained within a route table.
     */
    @JvmName("cumlnrcnlvqnsjto")
    public suspend fun routes(`value`: Output<List<RouteArgs>>) {
        this.routes = value
    }

    @JvmName("xkxmxxkspddeftmt")
    public suspend fun routes(vararg values: Output<RouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Collection of routes contained within a route table.
     */
    @JvmName("bqwtlmghkvhpkijy")
    public suspend fun routes(values: List<Output<RouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Collection of routes contained within a route table.
     */
    @JvmName("uinlhwifrmqwjxpo")
    public suspend fun routes(`value`: List<RouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     */
    @JvmName("tvxxdursdtmaxmpj")
    public suspend fun routes(argument: List<suspend RouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     */
    @JvmName("nogiggfppvumwwbb")
    public suspend fun routes(vararg argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RouteArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Collection of routes contained within a route table.
     */
    @JvmName("pksauolfxdnnldvf")
    public suspend fun routes(argument: suspend RouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RouteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Collection of routes contained within a route table.
     */
    @JvmName("ixmckuredscuvoqf")
    public suspend fun routes(vararg values: RouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    internal fun build(): RouteTableArgs = RouteTableArgs(
        routes = routes,
    )
}
