@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.SoftwareAssurancePropertiesArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.SoftwareAssuranceIntent
import com.pulumi.azurenative.azurestackhci.kotlin.enums.SoftwareAssuranceStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Software Assurance properties of the cluster.
 * @property softwareAssuranceIntent Customer Intent for Software Assurance Benefit.
 * @property softwareAssuranceStatus Status of the Software Assurance for the cluster.
 */
public data class SoftwareAssurancePropertiesArgs(
    public val softwareAssuranceIntent: Output<Either<String, SoftwareAssuranceIntent>>? = null,
    public val softwareAssuranceStatus: Output<Either<String, SoftwareAssuranceStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.SoftwareAssurancePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.SoftwareAssurancePropertiesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.SoftwareAssurancePropertiesArgs.builder()
            .softwareAssuranceIntent(
                softwareAssuranceIntent?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .softwareAssuranceStatus(
                softwareAssuranceStatus?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            ).build()
}

/**
 * Builder for [SoftwareAssurancePropertiesArgs].
 */
@PulumiTagMarker
public class SoftwareAssurancePropertiesArgsBuilder internal constructor() {
    private var softwareAssuranceIntent: Output<Either<String, SoftwareAssuranceIntent>>? = null

    private var softwareAssuranceStatus: Output<Either<String, SoftwareAssuranceStatus>>? = null

    /**
     * @param value Customer Intent for Software Assurance Benefit.
     */
    @JvmName("rimjpvluhdwpeann")
    public suspend
    fun softwareAssuranceIntent(`value`: Output<Either<String, SoftwareAssuranceIntent>>) {
        this.softwareAssuranceIntent = value
    }

    /**
     * @param value Status of the Software Assurance for the cluster.
     */
    @JvmName("njtyalomtopiqtfk")
    public suspend
    fun softwareAssuranceStatus(`value`: Output<Either<String, SoftwareAssuranceStatus>>) {
        this.softwareAssuranceStatus = value
    }

    /**
     * @param value Customer Intent for Software Assurance Benefit.
     */
    @JvmName("nixparcteojfqdhb")
    public suspend fun softwareAssuranceIntent(`value`: Either<String, SoftwareAssuranceIntent>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareAssuranceIntent = mapped
    }

    /**
     * @param value Customer Intent for Software Assurance Benefit.
     */
    @JvmName("rrfdmofgevtlwskq")
    public fun softwareAssuranceIntent(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SoftwareAssuranceIntent>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceIntent = mapped
    }

    /**
     * @param value Customer Intent for Software Assurance Benefit.
     */
    @JvmName("wtxlhheuafsfsdxg")
    public fun softwareAssuranceIntent(`value`: SoftwareAssuranceIntent) {
        val toBeMapped = Either.ofRight<String, SoftwareAssuranceIntent>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceIntent = mapped
    }

    /**
     * @param value Status of the Software Assurance for the cluster.
     */
    @JvmName("iabefenceuaqttgp")
    public suspend fun softwareAssuranceStatus(`value`: Either<String, SoftwareAssuranceStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softwareAssuranceStatus = mapped
    }

    /**
     * @param value Status of the Software Assurance for the cluster.
     */
    @JvmName("aslchiqeovscewfl")
    public fun softwareAssuranceStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SoftwareAssuranceStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceStatus = mapped
    }

    /**
     * @param value Status of the Software Assurance for the cluster.
     */
    @JvmName("ujmuoxoyciubqsob")
    public fun softwareAssuranceStatus(`value`: SoftwareAssuranceStatus) {
        val toBeMapped = Either.ofRight<String, SoftwareAssuranceStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.softwareAssuranceStatus = mapped
    }

    internal fun build(): SoftwareAssurancePropertiesArgs = SoftwareAssurancePropertiesArgs(
        softwareAssuranceIntent = softwareAssuranceIntent,
        softwareAssuranceStatus = softwareAssuranceStatus,
    )
}
