@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.StorageNetworksArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The StorageNetworks of a cluster.
 * @property name Name of the storage network.
 * @property networkAdapterName Name of the storage network adapter.
 * @property vlanId ID specified for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic.
 */
public data class StorageNetworksArgs(
    public val name: Output<String>? = null,
    public val networkAdapterName: Output<String>? = null,
    public val vlanId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.StorageNetworksArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.StorageNetworksArgs =
        com.pulumi.azurenative.azurestackhci.inputs.StorageNetworksArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .networkAdapterName(networkAdapterName?.applyValue({ args0 -> args0 }))
            .vlanId(vlanId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageNetworksArgs].
 */
@PulumiTagMarker
public class StorageNetworksArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var networkAdapterName: Output<String>? = null

    private var vlanId: Output<String>? = null

    /**
     * @param value Name of the storage network.
     */
    @JvmName("urlynbhdnqfcdsut")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the storage network adapter.
     */
    @JvmName("nltdbhtndofdagdr")
    public suspend fun networkAdapterName(`value`: Output<String>) {
        this.networkAdapterName = value
    }

    /**
     * @param value ID specified for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic.
     */
    @JvmName("qtlnfulggoraejdm")
    public suspend fun vlanId(`value`: Output<String>) {
        this.vlanId = value
    }

    /**
     * @param value Name of the storage network.
     */
    @JvmName("dlnotuesnrlswnca")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Name of the storage network adapter.
     */
    @JvmName("dwfkbnnbxuvchlnl")
    public suspend fun networkAdapterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAdapterName = mapped
    }

    /**
     * @param value ID specified for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic.
     */
    @JvmName("vcljkmvcyjxihjrj")
    public suspend fun vlanId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlanId = mapped
    }

    internal fun build(): StorageNetworksArgs = StorageNetworksArgs(
        name = name,
        networkAdapterName = networkAdapterName,
        vlanId = vlanId,
    )
}
