@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsDiskArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.OperatingSystemTypes
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VHD to attach as OS disk
 * @property id Resource ID of the OS disk
 * @property osType This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
 */
public data class VirtualMachineInstancePropertiesOsDiskArgs(
    public val id: Output<String>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsDiskArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsDiskArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsDiskArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesOsDiskArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesOsDiskArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    /**
     * @param value Resource ID of the OS disk
     */
    @JvmName("pvhgtpxhmjyubqry")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
     */
    @JvmName("saodmxepowtrxtkx")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value Resource ID of the OS disk
     */
    @JvmName("lcgmfbonsabloble")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value This property allows you to specify the type of the OS that is included in the disk if creating a VM from user-image or a specialized VHD. Possible values are: **Windows,** **Linux.**
     */
    @JvmName("adybnyosccxsjnux")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesOsDiskArgs =
        VirtualMachineInstancePropertiesOsDiskArgs(
            id = id,
            osType = osType,
        )
}
