@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * OsProfile - describes the configuration of the operating system and sets login data
 * @property adminPassword AdminPassword - admin password
 * @property adminUsername AdminUsername - admin username
 * @property computerName ComputerName - name of the compute
 * @property linuxConfiguration LinuxConfiguration - linux specific configuration values for the virtual machine instance
 * @property windowsConfiguration Windows Configuration for the virtual machine instance
 */
public data class VirtualMachineInstancePropertiesOsProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val computerName: Output<String>? = null,
    public val linuxConfiguration: Output<VirtualMachineInstancePropertiesLinuxConfigurationArgs>? =
        null,
    public val windowsConfiguration: Output<VirtualMachineInstancePropertiesWindowsConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesOsProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .computerName(computerName?.applyValue({ args0 -> args0 }))
            .linuxConfiguration(
                linuxConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .windowsConfiguration(
                windowsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesOsProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesOsProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var computerName: Output<String>? = null

    private var linuxConfiguration: Output<VirtualMachineInstancePropertiesLinuxConfigurationArgs>? =
        null

    private var windowsConfiguration:
        Output<VirtualMachineInstancePropertiesWindowsConfigurationArgs>? = null

    /**
     * @param value AdminPassword - admin password
     */
    @JvmName("kgqbioadtsiovsvj")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value AdminUsername - admin username
     */
    @JvmName("hacvmdxqtesivqjl")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value ComputerName - name of the compute
     */
    @JvmName("cyyinicuixdwswoq")
    public suspend fun computerName(`value`: Output<String>) {
        this.computerName = value
    }

    /**
     * @param value LinuxConfiguration - linux specific configuration values for the virtual machine instance
     */
    @JvmName("grswbyqfqfomiqvq")
    public suspend
    fun linuxConfiguration(`value`: Output<VirtualMachineInstancePropertiesLinuxConfigurationArgs>) {
        this.linuxConfiguration = value
    }

    /**
     * @param value Windows Configuration for the virtual machine instance
     */
    @JvmName("uuysqqxwnovsvhft")
    public suspend
    fun windowsConfiguration(`value`: Output<VirtualMachineInstancePropertiesWindowsConfigurationArgs>) {
        this.windowsConfiguration = value
    }

    /**
     * @param value AdminPassword - admin password
     */
    @JvmName("jnflqdhrmkxdafjn")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value AdminUsername - admin username
     */
    @JvmName("cuakxhwacgmucwoc")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value ComputerName - name of the compute
     */
    @JvmName("dokomcobbrdjicmg")
    public suspend fun computerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerName = mapped
    }

    /**
     * @param value LinuxConfiguration - linux specific configuration values for the virtual machine instance
     */
    @JvmName("vfbergmqxlvvghdu")
    public suspend
    fun linuxConfiguration(`value`: VirtualMachineInstancePropertiesLinuxConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxConfiguration = mapped
    }

    /**
     * @param argument LinuxConfiguration - linux specific configuration values for the virtual machine instance
     */
    @JvmName("hedmkvfrxlvgugmv")
    public suspend
    fun linuxConfiguration(argument: suspend VirtualMachineInstancePropertiesLinuxConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesLinuxConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.linuxConfiguration = mapped
    }

    /**
     * @param value Windows Configuration for the virtual machine instance
     */
    @JvmName("tfcpkyxevodhfact")
    public suspend
    fun windowsConfiguration(`value`: VirtualMachineInstancePropertiesWindowsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsConfiguration = mapped
    }

    /**
     * @param argument Windows Configuration for the virtual machine instance
     */
    @JvmName("lkyatpgihchitmoj")
    public suspend
    fun windowsConfiguration(argument: suspend VirtualMachineInstancePropertiesWindowsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachineInstancePropertiesWindowsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.windowsConfiguration = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesOsProfileArgs =
        VirtualMachineInstancePropertiesOsProfileArgs(
            adminPassword = adminPassword,
            adminUsername = adminUsername,
            computerName = computerName,
            linuxConfiguration = linuxConfiguration,
            windowsConfiguration = windowsConfiguration,
        )
}
