@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsProfileArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.OsTypeEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * OsProfile - describes the configuration of the operating system and sets login data
 * @property adminPassword AdminPassword - admin password
 * @property adminUsername AdminUsername - admin username
 * @property computerName ComputerName - name of the compute
 * @property linuxConfiguration LinuxConfiguration - linux specific configuration values for the virtual machine
 * @property osType OsType - string specifying whether the OS is Linux or Windows
 * @property windowsConfiguration Windows Configuration for the virtual machine
 */
public data class VirtualMachinePropertiesOsProfileArgs(
    public val adminPassword: Output<String>? = null,
    public val adminUsername: Output<String>? = null,
    public val computerName: Output<String>? = null,
    public val linuxConfiguration: Output<VirtualMachinePropertiesLinuxConfigurationArgs>? = null,
    public val osType: Output<Either<String, OsTypeEnum>>? = null,
    public val windowsConfiguration: Output<VirtualMachinePropertiesWindowsConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesOsProfileArgs.builder()
            .adminPassword(adminPassword?.applyValue({ args0 -> args0 }))
            .adminUsername(adminUsername?.applyValue({ args0 -> args0 }))
            .computerName(computerName?.applyValue({ args0 -> args0 }))
            .linuxConfiguration(
                linuxConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .osType(
                osType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .windowsConfiguration(
                windowsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachinePropertiesOsProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesOsProfileArgsBuilder internal constructor() {
    private var adminPassword: Output<String>? = null

    private var adminUsername: Output<String>? = null

    private var computerName: Output<String>? = null

    private var linuxConfiguration: Output<VirtualMachinePropertiesLinuxConfigurationArgs>? = null

    private var osType: Output<Either<String, OsTypeEnum>>? = null

    private var windowsConfiguration: Output<VirtualMachinePropertiesWindowsConfigurationArgs>? = null

    /**
     * @param value AdminPassword - admin password
     */
    @JvmName("rcerrcmnwhldtihq")
    public suspend fun adminPassword(`value`: Output<String>) {
        this.adminPassword = value
    }

    /**
     * @param value AdminUsername - admin username
     */
    @JvmName("xtrjggcdforunkgr")
    public suspend fun adminUsername(`value`: Output<String>) {
        this.adminUsername = value
    }

    /**
     * @param value ComputerName - name of the compute
     */
    @JvmName("uqflumklmretchum")
    public suspend fun computerName(`value`: Output<String>) {
        this.computerName = value
    }

    /**
     * @param value LinuxConfiguration - linux specific configuration values for the virtual machine
     */
    @JvmName("yvpfbrekmfspiprr")
    public suspend
    fun linuxConfiguration(`value`: Output<VirtualMachinePropertiesLinuxConfigurationArgs>) {
        this.linuxConfiguration = value
    }

    /**
     * @param value OsType - string specifying whether the OS is Linux or Windows
     */
    @JvmName("ltihiverffnfuuln")
    public suspend fun osType(`value`: Output<Either<String, OsTypeEnum>>) {
        this.osType = value
    }

    /**
     * @param value Windows Configuration for the virtual machine
     */
    @JvmName("xkbmqvkeoullcjth")
    public suspend
    fun windowsConfiguration(`value`: Output<VirtualMachinePropertiesWindowsConfigurationArgs>) {
        this.windowsConfiguration = value
    }

    /**
     * @param value AdminPassword - admin password
     */
    @JvmName("dscyvfpqlbhjmgya")
    public suspend fun adminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminPassword = mapped
    }

    /**
     * @param value AdminUsername - admin username
     */
    @JvmName("pypsaidptynvmcre")
    public suspend fun adminUsername(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUsername = mapped
    }

    /**
     * @param value ComputerName - name of the compute
     */
    @JvmName("xjgdyhryhxtflijo")
    public suspend fun computerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computerName = mapped
    }

    /**
     * @param value LinuxConfiguration - linux specific configuration values for the virtual machine
     */
    @JvmName("kctsfphrmaxryvgf")
    public suspend fun linuxConfiguration(`value`: VirtualMachinePropertiesLinuxConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linuxConfiguration = mapped
    }

    /**
     * @param argument LinuxConfiguration - linux specific configuration values for the virtual machine
     */
    @JvmName("mmeaqjkijvyhftfo")
    public suspend
    fun linuxConfiguration(argument: suspend VirtualMachinePropertiesLinuxConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesLinuxConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.linuxConfiguration = mapped
    }

    /**
     * @param value OsType - string specifying whether the OS is Linux or Windows
     */
    @JvmName("agutnjjvgpeodnox")
    public suspend fun osType(`value`: Either<String, OsTypeEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType - string specifying whether the OS is Linux or Windows
     */
    @JvmName("lwmspmiflfoqgayy")
    public fun osType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OsTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value OsType - string specifying whether the OS is Linux or Windows
     */
    @JvmName("kqxlluarlrhwmwyc")
    public fun osType(`value`: OsTypeEnum) {
        val toBeMapped = Either.ofRight<String, OsTypeEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value Windows Configuration for the virtual machine
     */
    @JvmName("uyckkccttgfdwfaa")
    public suspend
    fun windowsConfiguration(`value`: VirtualMachinePropertiesWindowsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.windowsConfiguration = mapped
    }

    /**
     * @param argument Windows Configuration for the virtual machine
     */
    @JvmName("kssqffgmvvuahnva")
    public suspend
    fun windowsConfiguration(argument: suspend VirtualMachinePropertiesWindowsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualMachinePropertiesWindowsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.windowsConfiguration = mapped
    }

    internal fun build(): VirtualMachinePropertiesOsProfileArgs =
        VirtualMachinePropertiesOsProfileArgs(
            adminPassword = adminPassword,
            adminUsername = adminUsername,
            computerName = computerName,
            linuxConfiguration = linuxConfiguration,
            osType = osType,
            windowsConfiguration = windowsConfiguration,
        )
}
