@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshSshArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSH Configuration
 * @property publicKeys PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
 */
public data class VirtualMachinePropertiesSshSshArgs(
    public val publicKeys: Output<List<VirtualMachinePropertiesPublicKeysPublicKeysArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshSshArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshSshArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachinePropertiesSshSshArgs.builder()
            .publicKeys(
                publicKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachinePropertiesSshSshArgs].
 */
@PulumiTagMarker
public class VirtualMachinePropertiesSshSshArgsBuilder internal constructor() {
    private var publicKeys: Output<List<VirtualMachinePropertiesPublicKeysPublicKeysArgs>>? = null

    /**
     * @param value PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("vuerqwnepwncpife")
    public suspend
    fun publicKeys(`value`: Output<List<VirtualMachinePropertiesPublicKeysPublicKeysArgs>>) {
        this.publicKeys = value
    }

    @JvmName("bacrbeaaoyvwphxs")
    public suspend fun publicKeys(
        vararg
        values: Output<VirtualMachinePropertiesPublicKeysPublicKeysArgs>,
    ) {
        this.publicKeys = Output.all(values.asList())
    }

    /**
     * @param values PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("agljfaevakkvxetw")
    public suspend
    fun publicKeys(values: List<Output<VirtualMachinePropertiesPublicKeysPublicKeysArgs>>) {
        this.publicKeys = Output.all(values)
    }

    /**
     * @param value PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("aegyigthxasegxln")
    public suspend fun publicKeys(`value`: List<VirtualMachinePropertiesPublicKeysPublicKeysArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("wqmaudwtbumlgvwb")
    public suspend
    fun publicKeys(argument: List<suspend VirtualMachinePropertiesPublicKeysPublicKeysArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesPublicKeysPublicKeysArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("qnnitwtavqnccsmc")
    public suspend fun publicKeys(
        vararg
        argument: suspend VirtualMachinePropertiesPublicKeysPublicKeysArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachinePropertiesPublicKeysPublicKeysArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param argument PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("ndvrknvfpsndknal")
    public suspend
    fun publicKeys(argument: suspend VirtualMachinePropertiesPublicKeysPublicKeysArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualMachinePropertiesPublicKeysPublicKeysArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.publicKeys = mapped
    }

    /**
     * @param values PublicKeys - The list of SSH public keys used to authenticate with linux based VMs.
     */
    @JvmName("viohlujkjvpikwhk")
    public suspend fun publicKeys(vararg values: VirtualMachinePropertiesPublicKeysPublicKeysArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicKeys = mapped
    }

    internal fun build(): VirtualMachinePropertiesSshSshArgs = VirtualMachinePropertiesSshSshArgs(
        publicKeys = publicKeys,
    )
}
