@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRouteTableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * RouteTable for the subnet
 * @property id Etag - Gets a unique read-only string that changes whenever the resource is updated.
 * @property name Name - READ-ONLY; Resource name.
 * @property routes Routes - Collection of routes contained within a route table.
 * @property type Type - READ-ONLY; Resource type.
 */
public data class VirtualNetworkPropertiesRouteTableArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val routes: Output<List<VirtualNetworkPropertiesRoutesArgs>>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRouteTableArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRouteTableArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesRouteTableArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkPropertiesRouteTableArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPropertiesRouteTableArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var routes: Output<List<VirtualNetworkPropertiesRoutesArgs>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Etag - Gets a unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("tkpakmslhpupyrcu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name - READ-ONLY; Resource name.
     */
    @JvmName("hbryfewdioiavaou")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Routes - Collection of routes contained within a route table.
     */
    @JvmName("pcykoqshalgejmgt")
    public suspend fun routes(`value`: Output<List<VirtualNetworkPropertiesRoutesArgs>>) {
        this.routes = value
    }

    @JvmName("nvsfajubccbniiwe")
    public suspend fun routes(vararg values: Output<VirtualNetworkPropertiesRoutesArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Routes - Collection of routes contained within a route table.
     */
    @JvmName("ihsjtpdwjufsroio")
    public suspend fun routes(values: List<Output<VirtualNetworkPropertiesRoutesArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Type - READ-ONLY; Resource type.
     */
    @JvmName("rkywugnonxlblwnn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Etag - Gets a unique read-only string that changes whenever the resource is updated.
     */
    @JvmName("cxfqlnsfxdqmytxh")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name - READ-ONLY; Resource name.
     */
    @JvmName("gsrgdmdfsexvbroq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Routes - Collection of routes contained within a route table.
     */
    @JvmName("hgnkjmurtsofohdq")
    public suspend fun routes(`value`: List<VirtualNetworkPropertiesRoutesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Routes - Collection of routes contained within a route table.
     */
    @JvmName("sidhpneuororioai")
    public suspend
    fun routes(argument: List<suspend VirtualNetworkPropertiesRoutesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesRoutesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Routes - Collection of routes contained within a route table.
     */
    @JvmName("hqrwxrjcfikfkinp")
    public suspend fun routes(
        vararg
        argument: suspend VirtualNetworkPropertiesRoutesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesRoutesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Routes - Collection of routes contained within a route table.
     */
    @JvmName("tsswslanohxcbdte")
    public suspend
    fun routes(argument: suspend VirtualNetworkPropertiesRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VirtualNetworkPropertiesRoutesArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Routes - Collection of routes contained within a route table.
     */
    @JvmName("yppvthbbyfbcoeeu")
    public suspend fun routes(vararg values: VirtualNetworkPropertiesRoutesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value Type - READ-ONLY; Resource type.
     */
    @JvmName("hvqircnisdqysvvq")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): VirtualNetworkPropertiesRouteTableArgs =
        VirtualNetworkPropertiesRouteTableArgs(
            id = id,
            name = name,
            routes = routes,
            type = type,
        )
}
