@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesSubnetsArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.IpAllocationMethodEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Subnet subnet in a virtual network resource.
 * @property addressPrefix Cidr for this subnet - IPv4, IPv6
 * @property addressPrefixes AddressPrefixes - List of address prefixes for the subnet.
 * @property ipAllocationMethod IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
 * @property ipConfigurationReferences IPConfigurationReferences - list of IPConfigurationReferences
 * @property ipPools network associated pool of IP Addresses
 * @property name Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property routeTable RouteTable for the subnet
 * @property vlan Vlan to use for the subnet
 */
public data class VirtualNetworkPropertiesSubnetsArgs(
    public val addressPrefix: Output<String>? = null,
    public val addressPrefixes: Output<List<String>>? = null,
    public val ipAllocationMethod: Output<Either<String, IpAllocationMethodEnum>>? = null,
    public val ipConfigurationReferences:
    Output<List<VirtualNetworkPropertiesIpConfigurationReferencesArgs>>? = null,
    public val ipPools: Output<List<IPPoolArgs>>? = null,
    public val name: Output<String>? = null,
    public val routeTable: Output<VirtualNetworkPropertiesRouteTableArgs>? = null,
    public val vlan: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesSubnetsArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesSubnetsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualNetworkPropertiesSubnetsArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .addressPrefixes(addressPrefixes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .ipAllocationMethod(
                ipAllocationMethod?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipConfigurationReferences(
                ipConfigurationReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .ipPools(
                ipPools?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .routeTable(routeTable?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualNetworkPropertiesSubnetsArgs].
 */
@PulumiTagMarker
public class VirtualNetworkPropertiesSubnetsArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var addressPrefixes: Output<List<String>>? = null

    private var ipAllocationMethod: Output<Either<String, IpAllocationMethodEnum>>? = null

    private var ipConfigurationReferences:
        Output<List<VirtualNetworkPropertiesIpConfigurationReferencesArgs>>? = null

    private var ipPools: Output<List<IPPoolArgs>>? = null

    private var name: Output<String>? = null

    private var routeTable: Output<VirtualNetworkPropertiesRouteTableArgs>? = null

    private var vlan: Output<Int>? = null

    /**
     * @param value Cidr for this subnet - IPv4, IPv6
     */
    @JvmName("moxatcetkdedfsdg")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value AddressPrefixes - List of address prefixes for the subnet.
     */
    @JvmName("egkshhfmvaejcnbm")
    public suspend fun addressPrefixes(`value`: Output<List<String>>) {
        this.addressPrefixes = value
    }

    @JvmName("csfxoqmweuybdcyc")
    public suspend fun addressPrefixes(vararg values: Output<String>) {
        this.addressPrefixes = Output.all(values.asList())
    }

    /**
     * @param values AddressPrefixes - List of address prefixes for the subnet.
     */
    @JvmName("jiwejwhaurmwhvcw")
    public suspend fun addressPrefixes(values: List<Output<String>>) {
        this.addressPrefixes = Output.all(values)
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("nampblfxbtaawlng")
    public suspend fun ipAllocationMethod(`value`: Output<Either<String, IpAllocationMethodEnum>>) {
        this.ipAllocationMethod = value
    }

    /**
     * @param value IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("bpnbldjlpuxcxbth")
    public suspend
    fun ipConfigurationReferences(`value`: Output<List<VirtualNetworkPropertiesIpConfigurationReferencesArgs>>) {
        this.ipConfigurationReferences = value
    }

    @JvmName("sjcmtjahxtvqkoya")
    public suspend fun ipConfigurationReferences(
        vararg
        values: Output<VirtualNetworkPropertiesIpConfigurationReferencesArgs>,
    ) {
        this.ipConfigurationReferences = Output.all(values.asList())
    }

    /**
     * @param values IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("eclnpjngquhokdod")
    public suspend
    fun ipConfigurationReferences(values: List<Output<VirtualNetworkPropertiesIpConfigurationReferencesArgs>>) {
        this.ipConfigurationReferences = Output.all(values)
    }

    /**
     * @param value network associated pool of IP Addresses
     */
    @JvmName("tqwfyxsxgtvwkjcw")
    public suspend fun ipPools(`value`: Output<List<IPPoolArgs>>) {
        this.ipPools = value
    }

    @JvmName("jliconnjvtgsapjg")
    public suspend fun ipPools(vararg values: Output<IPPoolArgs>) {
        this.ipPools = Output.all(values.asList())
    }

    /**
     * @param values network associated pool of IP Addresses
     */
    @JvmName("stvjrkpdxgnnpifl")
    public suspend fun ipPools(values: List<Output<IPPoolArgs>>) {
        this.ipPools = Output.all(values)
    }

    /**
     * @param value Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("dlckbftckuvwtdjr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value RouteTable for the subnet
     */
    @JvmName("ojhvbshdofrfgwqc")
    public suspend fun routeTable(`value`: Output<VirtualNetworkPropertiesRouteTableArgs>) {
        this.routeTable = value
    }

    /**
     * @param value Vlan to use for the subnet
     */
    @JvmName("nogggjipkqsmrkjt")
    public suspend fun vlan(`value`: Output<Int>) {
        this.vlan = value
    }

    /**
     * @param value Cidr for this subnet - IPv4, IPv6
     */
    @JvmName("cqqrbopljxrndoir")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value AddressPrefixes - List of address prefixes for the subnet.
     */
    @JvmName("ahrmjviwvqrgqpce")
    public suspend fun addressPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param values AddressPrefixes - List of address prefixes for the subnet.
     */
    @JvmName("dlkodwvqjbvjswii")
    public suspend fun addressPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addressPrefixes = mapped
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("cfcoqdqeatqxsjsk")
    public suspend fun ipAllocationMethod(`value`: Either<String, IpAllocationMethodEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("ftdircobyplfrgdb")
    public fun ipAllocationMethod(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpAllocationMethodEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IPAllocationMethod - The IP address allocation method. Possible values include: 'Static', 'Dynamic'
     */
    @JvmName("macekgqjrksqhvdg")
    public fun ipAllocationMethod(`value`: IpAllocationMethodEnum) {
        val toBeMapped = Either.ofRight<String, IpAllocationMethodEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationMethod = mapped
    }

    /**
     * @param value IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("bqlsqwxpjtracjva")
    public suspend
    fun ipConfigurationReferences(`value`: List<VirtualNetworkPropertiesIpConfigurationReferencesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param argument IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("ppwhboikpwrtxdgg")
    public suspend
    fun ipConfigurationReferences(argument: List<suspend VirtualNetworkPropertiesIpConfigurationReferencesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesIpConfigurationReferencesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param argument IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("glpcunpxkqhyujjw")
    public suspend fun ipConfigurationReferences(
        vararg
        argument: suspend VirtualNetworkPropertiesIpConfigurationReferencesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualNetworkPropertiesIpConfigurationReferencesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param argument IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("iqbwcmmrhocgvfkb")
    public suspend
    fun ipConfigurationReferences(argument: suspend VirtualNetworkPropertiesIpConfigurationReferencesArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                VirtualNetworkPropertiesIpConfigurationReferencesArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param values IPConfigurationReferences - list of IPConfigurationReferences
     */
    @JvmName("bcwirlvutdaudnpn")
    public suspend fun ipConfigurationReferences(
        vararg
        values: VirtualNetworkPropertiesIpConfigurationReferencesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipConfigurationReferences = mapped
    }

    /**
     * @param value network associated pool of IP Addresses
     */
    @JvmName("ohaordonoahktptj")
    public suspend fun ipPools(`value`: List<IPPoolArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipPools = mapped
    }

    /**
     * @param argument network associated pool of IP Addresses
     */
    @JvmName("fneugttiruumunid")
    public suspend fun ipPools(argument: List<suspend IPPoolArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IPPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param argument network associated pool of IP Addresses
     */
    @JvmName("ewuognpscyuvufjt")
    public suspend fun ipPools(vararg argument: suspend IPPoolArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IPPoolArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param argument network associated pool of IP Addresses
     */
    @JvmName("pwoluwkxogrtviqe")
    public suspend fun ipPools(argument: suspend IPPoolArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IPPoolArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipPools = mapped
    }

    /**
     * @param values network associated pool of IP Addresses
     */
    @JvmName("fwrcwsrcrcyccgnn")
    public suspend fun ipPools(vararg values: IPPoolArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipPools = mapped
    }

    /**
     * @param value Name - The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("wvfjpngmhiapllbn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value RouteTable for the subnet
     */
    @JvmName("ypyiustocrlikllf")
    public suspend fun routeTable(`value`: VirtualNetworkPropertiesRouteTableArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTable = mapped
    }

    /**
     * @param argument RouteTable for the subnet
     */
    @JvmName("itabfygpwuouqmqn")
    public suspend
    fun routeTable(argument: suspend VirtualNetworkPropertiesRouteTableArgsBuilder.() -> Unit) {
        val toBeMapped = VirtualNetworkPropertiesRouteTableArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.routeTable = mapped
    }

    /**
     * @param value Vlan to use for the subnet
     */
    @JvmName("ltoiwhrbkofmcgdj")
    public suspend fun vlan(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): VirtualNetworkPropertiesSubnetsArgs = VirtualNetworkPropertiesSubnetsArgs(
        addressPrefix = addressPrefix,
        addressPrefixes = addressPrefixes,
        ipAllocationMethod = ipAllocationMethod,
        ipConfigurationReferences = ipConfigurationReferences,
        ipPools = ipPools,
        name = name,
        routeTable = routeTable,
        vlan = vlan,
    )
}
