@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualSwitchConfigurationOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The VirtualSwitchConfigurationOverrides of a cluster.
 * @property enableIov Enable IoV for Virtual Switch
 * @property loadBalancingAlgorithm Load Balancing Algorithm for Virtual Switch
 */
public data class VirtualSwitchConfigurationOverridesArgs(
    public val enableIov: Output<String>? = null,
    public val loadBalancingAlgorithm: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualSwitchConfigurationOverridesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualSwitchConfigurationOverridesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualSwitchConfigurationOverridesArgs.builder()
            .enableIov(enableIov?.applyValue({ args0 -> args0 }))
            .loadBalancingAlgorithm(loadBalancingAlgorithm?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualSwitchConfigurationOverridesArgs].
 */
@PulumiTagMarker
public class VirtualSwitchConfigurationOverridesArgsBuilder internal constructor() {
    private var enableIov: Output<String>? = null

    private var loadBalancingAlgorithm: Output<String>? = null

    /**
     * @param value Enable IoV for Virtual Switch
     */
    @JvmName("ekyiygermsjdxhwv")
    public suspend fun enableIov(`value`: Output<String>) {
        this.enableIov = value
    }

    /**
     * @param value Load Balancing Algorithm for Virtual Switch
     */
    @JvmName("tmexiraxtbppdbsq")
    public suspend fun loadBalancingAlgorithm(`value`: Output<String>) {
        this.loadBalancingAlgorithm = value
    }

    /**
     * @param value Enable IoV for Virtual Switch
     */
    @JvmName("ivqawyarnxgtgtqi")
    public suspend fun enableIov(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableIov = mapped
    }

    /**
     * @param value Load Balancing Algorithm for Virtual Switch
     */
    @JvmName("pwmxktygpialiyip")
    public suspend fun loadBalancingAlgorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loadBalancingAlgorithm = mapped
    }

    internal fun build(): VirtualSwitchConfigurationOverridesArgs =
        VirtualSwitchConfigurationOverridesArgs(
            enableIov = enableIov,
            loadBalancingAlgorithm = loadBalancingAlgorithm,
        )
}
