@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Desired properties of the cluster.
 * @property diagnosticLevel Desired level of diagnostic data emitted by the cluster.
 * @property windowsServerSubscription Desired state of Windows Server Subscription.
 */
public data class ClusterDesiredPropertiesResponse(
    public val diagnosticLevel: String? = null,
    public val windowsServerSubscription: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.ClusterDesiredPropertiesResponse):
            ClusterDesiredPropertiesResponse = ClusterDesiredPropertiesResponse(
            diagnosticLevel = javaType.diagnosticLevel().map({ args0 -> args0 }).orElse(null),
            windowsServerSubscription = javaType.windowsServerSubscription().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
