@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Deployment Configuration
 * @property scaleUnits Scale units will contains list of deployment data
 * @property version deployment template version
 */
public data class DeploymentConfigurationResponse(
    public val scaleUnits: List<ScaleUnitsResponse>,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.DeploymentConfigurationResponse):
            DeploymentConfigurationResponse = DeploymentConfigurationResponse(
            scaleUnits = javaType.scaleUnits().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ScaleUnitsResponse.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
