@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The logical network resource definition.
 * @property dhcpOptions DhcpOptions contains an array of DNS servers available to VMs deployed in the logical network. Standard DHCP option for a subnet overrides logical network DHCP options.
 * @property extendedLocation The extendedLocation of the resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provisioning state of the logical network.
 * @property status The observed state of logical networks
 * @property subnets Subnet - list of subnets under the logical network
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property vmSwitchName name of the network switch to be used for VMs
 */
public data class GetLogicalNetworkResult(
    public val dhcpOptions: LogicalNetworkPropertiesResponseDhcpOptions? = null,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val status: LogicalNetworkStatusResponse,
    public val subnets: List<SubnetResponse>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vmSwitchName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetLogicalNetworkResult):
            GetLogicalNetworkResult = GetLogicalNetworkResult(
            dhcpOptions = javaType.dhcpOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.LogicalNetworkPropertiesResponseDhcpOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.LogicalNetworkStatusResponse.Companion.toKotlin(args0)
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vmSwitchName = javaType.vmSwitchName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
