@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Get the update summaries for the cluster
 * @property currentVersion Current Solution Bundle version of the stamp.
 * @property hardwareModel Name of the hardware model.
 * @property healthCheckDate Last time the package-specific checks were run.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastChecked Last time the update service successfully checked for updates
 * @property lastUpdated Last time an update installation completed successfully.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property oemFamily OEM family name.
 * @property provisioningState Provisioning state of the UpdateSummaries proxy resource.
 * @property state Overall update state of the stamp.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetUpdateSummaryResult(
    public val currentVersion: String? = null,
    public val hardwareModel: String? = null,
    public val healthCheckDate: String? = null,
    public val id: String,
    public val lastChecked: String? = null,
    public val lastUpdated: String? = null,
    public val location: String? = null,
    public val name: String,
    public val oemFamily: String? = null,
    public val provisioningState: String,
    public val state: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.GetUpdateSummaryResult):
            GetUpdateSummaryResult = GetUpdateSummaryResult(
            currentVersion = javaType.currentVersion().map({ args0 -> args0 }).orElse(null),
            hardwareModel = javaType.hardwareModel().map({ args0 -> args0 }).orElse(null),
            healthCheckDate = javaType.healthCheckDate().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lastChecked = javaType.lastChecked().map({ args0 -> args0 }).orElse(null),
            lastUpdated = javaType.lastUpdated().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            oemFamily = javaType.oemFamily().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
