@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * InterfaceIPConfigurationPropertiesFormat properties of IP configuration.
 * @property prefixLength prefixLength for network interface
 * @property privateIPAddress PrivateIPAddress - Private IP address of the IP configuration.
 * @property privateIPAllocationMethod PrivateIPAllocationMethod - The private IP address allocation method. Possible values include: 'Static', 'Dynamic'
 * @property subnet Subnet - Name of Subnet bound to the IP configuration.
 */
public data class IPConfigurationResponseProperties(
    public val prefixLength: String? = null,
    public val privateIPAddress: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val subnet: IPConfigurationResponseSubnet? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.IPConfigurationResponseProperties):
            IPConfigurationResponseProperties = IPConfigurationResponseProperties(
            prefixLength = javaType.prefixLength().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurestackhci.kotlin.outputs.IPConfigurationResponseSubnet.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
