@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The dnsServers of a device.
 * @property endingAddress Ending IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
 * @property startingAddress Starting IP address for the management network. A minimum of six free, contiguous IPv4 addresses (excluding your host IPs) are needed for infrastructure services such as clustering.
 */
public data class IpPoolsResponse(
    public val endingAddress: String? = null,
    public val startingAddress: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.IpPoolsResponse):
            IpPoolsResponse = IpPoolsResponse(
            endingAddress = javaType.endingAddress().map({ args0 -> args0 }).orElse(null),
            startingAddress = javaType.startingAddress().map({ args0 -> args0 }).orElse(null),
        )
    }
}
