@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Instance view status.
 * @property code The status code.
 * @property displayStatus The short localizable label for the status.
 * @property level The level code.
 * @property message The detailed status message, including for alerts and error messages.
 * @property time The time of the status.
 */
public data class MachineExtensionInstanceViewResponseStatus(
    public val code: String,
    public val displayStatus: String,
    public val level: String,
    public val message: String,
    public val time: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.outputs.MachineExtensionInstanceViewResponseStatus):
            MachineExtensionInstanceViewResponseStatus = MachineExtensionInstanceViewResponseStatus(
            code = javaType.code(),
            displayStatus = javaType.displayStatus(),
            level = javaType.level(),
            message = javaType.message(),
            time = javaType.time(),
        )
    }
}
